/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.converter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.DistanceMatrixWriterParamView;
import simpletree.distance.converter.DistanceMatrixConverterComp;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.DMATFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class DistanceMatrixConverterParamView
extends AbstractParametersView {
    private DistanceMatrixConverterComp comp;
    private JPanel algorithmPanel;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JButton distmatrixButton;
    private JLabel distmatrixLabel;
    private JTextField distmatrixTextField;

    public DistanceMatrixConverterParamView(DistanceMatrixConverterComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType type : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(type);
        }
        this.reset();
    }

    private void initComponents() {
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.algorithmPanel = new JPanel();
        this.distmatrixLabel = new JLabel();
        this.distmatrixTextField = new JTextField();
        this.distmatrixButton = new JButton();
        this.setBorder(BorderFactory.createTitledBorder("Distance Matrix Converter Parameters"));
        this.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.algorithmPanel.setBorder(BorderFactory.createTitledBorder("Output Parameters"));
        this.distmatrixLabel.setText("File name");
        this.algorithmPanel.add(this.distmatrixLabel);
        this.distmatrixTextField.setColumns(35);
        this.distmatrixTextField.setMinimumSize(new Dimension(286, 20));
        this.algorithmPanel.add(this.distmatrixTextField);
        this.distmatrixButton.setText("Search...");
        this.distmatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceMatrixConverterParamView.this.distmatrixButtonActionPerformed(evt);
            }
        });
        this.algorithmPanel.add(this.distmatrixButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add(this.algorithmPanel, gridBagConstraints);
    }

    private void distmatrixButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            int result = SaveDialog.showSaveDialog(spm, new DMATFilter(), (Component)((Object)this), "distancematrix.dmat");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                this.distmatrixTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DistanceMatrixWriterParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reset() {
        this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        this.distmatrixTextField.setText(this.comp.getFilename());
    }

    public void finished() throws IOException {
        this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        this.comp.setFilename(this.distmatrixTextField.getText().trim());
    }
}

