/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.dissimilarity;

import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseVector;
import simpletree.matrix.sparse.SparseVector;

public class CityBlock
implements AbstractDissimilarity {
    @Override
    public float calculate(AbstractVector v1, AbstractVector v2) {
        assert (v1.size() == v2.size()) : "ERROR: vectors of different sizes!";
        assert (v1.getClass() == v2.getClass()) : "Error: only supported comparing vectors of the same type";
        if (v1 instanceof SparseVector) {
            if (((SparseVector)v2).getIndex().length > ((SparseVector)v1).getIndex().length) {
                SparseVector tmp = (SparseVector)v1;
                v1 = v2;
                v2 = tmp;
            }
            int v1length = ((SparseVector)v1).getIndex().length;
            int v2length = ((SparseVector)v2).getIndex().length;
            int[] v1index = ((SparseVector)v1).getIndex();
            int[] v2index = ((SparseVector)v2).getIndex();
            float[] v1values = v1.getValues();
            float[] v2values = v2.getValues();
            int i = 0;
            int j = 0;
            float dist = 0.0f;
            while (i < v1length && j < v2length) {
                if (v1index[i] == v2index[j]) {
                    dist += Math.abs(v1values[i] - v2values[j]);
                    ++i;
                    ++j;
                    continue;
                }
                if (v1index[i] < v2index[j]) {
                    dist += Math.abs(v1values[i]);
                    ++i;
                    continue;
                }
                dist += Math.abs(v2values[j]);
                ++j;
            }
            while (i < v1length) {
                dist += Math.abs(v1values[i]);
                ++i;
            }
            while (j < v2length) {
                dist += Math.abs(v2values[j]);
                ++j;
            }
            return dist;
        }
        if (v1 instanceof DenseVector) {
            float[] vector1 = v1.getValues();
            float[] vector2 = v2 instanceof DenseVector ? v2.getValues() : v2.toArray();
            float dist = 0.0f;
            int length = vector1.length;
            for (int i = 0; i < length; ++i) {
                dist += Math.abs(vector1[i] - vector2[i]);
            }
            return dist;
        }
        return 0.0f;
    }
}

