/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.dissimilarity;

import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.sparse.SparseVector;

public class DynamicTimeWarping
implements AbstractDissimilarity {
    private static float[][] g;
    private float warpingWindowPerc;
    private int warpingWindowSize;

    public DynamicTimeWarping() {
        this(0.25f);
    }

    public DynamicTimeWarping(float warpingWindowPerc) {
        this.warpingWindowPerc = warpingWindowPerc;
        this.warpingWindowSize = -1;
    }

    public DynamicTimeWarping(int warpingWindowSize) {
        this.warpingWindowSize = warpingWindowSize;
        this.warpingWindowPerc = -1.0f;
    }

    @Override
    public float calculate(AbstractVector v1, AbstractVector v2) {
        assert (v1.size() == v2.size()) : "ERROR: vectors of different sizes!";
        float[] a = v1.getValues();
        float[] b = v2.getValues();
        if (v1 instanceof SparseVector) {
            a = v1.toArray();
        }
        if (v2 instanceof SparseVector) {
            b = v2.toArray();
        }
        if (g == null || g.length < a.length) {
            g = new float[a.length][b.length];
        }
        DynamicTimeWarping.g[0][0] = this.dist(a[0], b[0]);
        int r = this.warpingWindowSize;
        if (this.warpingWindowSize == -1) {
            r = (int)((float)(a.length - 1) * this.warpingWindowPerc);
        }
        int i = r + 1;
        int j = 0;
        while (i < b.length) {
            DynamicTimeWarping.g[i][j] = Float.POSITIVE_INFINITY;
            DynamicTimeWarping.g[j][i] = Float.POSITIVE_INFINITY;
            ++i;
            ++j;
        }
        for (i = 1; i <= r; ++i) {
            DynamicTimeWarping.g[0][i] = g[0][i - 1] + this.dist(a[i], b[0]);
            DynamicTimeWarping.g[i][0] = g[i - 1][0] + this.dist(a[0], b[i]);
        }
        for (i = 1; i < b.length; ++i) {
            int min = Math.max(1, i - r);
            int max = Math.min(a.length - 1, i + r);
            for (int j2 = min; j2 <= max; ++j2) {
                DynamicTimeWarping.g[i][j2] = Math.min(Math.min(g[i - 1][j2], g[i - 1][j2 - 1]), g[i][j2 - 1]) + this.dist(a[j2], b[i]);
            }
        }
        return g[a.length - 1][b.length - 1];
    }

    private float dist(float a, float b) {
        float diff = a - b;
        return (float)Math.sqrt(diff * diff);
    }
}

