/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.dissimilarity;

import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractVector;

public class HistogLog
implements AbstractDissimilarity {
    @Override
    public float calculate(AbstractVector v1, AbstractVector v2) {
        float[] q = v1.toArray();
        float[] d = v2.toArray();
        int sum = 0;
        int nf = q.length;
        for (int i = 0; i < nf; ++i) {
            int qi = (int)q[i];
            int di = (int)d[i];
            sum += (int)Math.abs(this.funcionLlog(qi) - this.funcionLlog(di));
        }
        return sum;
    }

    double funcionLlog(int valor) {
        double result = 0.0;
        if (valor == 0) {
            result = 0.0;
        } else if (valor > 0 && valor <= 1) {
            result = 1.0;
        } else {
            result = this.log2(valor);
            result = Math.ceil(result) + 1.0;
        }
        return result;
    }

    double log2(double num) {
        return Math.log(num) / Math.log(2.0);
    }
}

