/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.histogLog;

import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.HistogLog;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;

public class histogLogDistance {
    public DistanceMatrix transform(AbstractMatrix matrix) {
        HistogLog diss = new HistogLog();
        float beta = 0.0f;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            for (int j = 0; j < matrix.getRowCount(); ++j) {
                beta += diss.calculate(matrix.getRow(i), matrix.getRow(j));
            }
        }
        beta = (float)(matrix.getRowCount() * matrix.getRowCount() - matrix.getRowCount()) / beta;
        DistanceMatrix dmat = new DistanceMatrix(matrix.getRowCount());
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            for (int j = 0; j < i; ++j) {
                float dist = (float)Math.sqrt(this.hlog(beta, matrix.getRow(i), matrix.getRow(i)) - 2.0f * this.hlog(beta, matrix.getRow(i), matrix.getRow(j)) + this.hlog(beta, matrix.getRow(j), matrix.getRow(j)));
                dmat.setDistance(i, j, dist);
            }
        }
        dmat.setClassData(matrix.getClassData());
        dmat.setIds(matrix.getIds());
        return dmat;
    }

    private float hlog(float beta, AbstractVector v1, AbstractVector v2) {
        HistogLog diss = new HistogLog();
        return (float)Math.exp(-beta * diss.calculate(v1, v2));
    }
}

