/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.kernel;

import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;

public class KernelDistance {
    public DistanceMatrix transform(AbstractMatrix matrix) {
        Euclidean diss = new Euclidean();
        float beta = 0.0f;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            for (int j = 0; j < matrix.getRowCount(); ++j) {
                beta += diss.calculate(matrix.getRow(i), matrix.getRow(j));
            }
        }
        beta = (float)(matrix.getRowCount() * matrix.getRowCount() - matrix.getRowCount()) / beta;
        DistanceMatrix dmat = new DistanceMatrix(matrix.getRowCount());
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            for (int j = 0; j < i; ++j) {
                float dist = (float)Math.sqrt(this.kernel(beta, matrix.getRow(i), matrix.getRow(i)) - 2.0f * this.kernel(beta, matrix.getRow(i), matrix.getRow(j)) + this.kernel(beta, matrix.getRow(j), matrix.getRow(j)));
                dmat.setDistance(i, j, dist);
            }
        }
        dmat.setClassData(matrix.getClassData());
        dmat.setIds(matrix.getIds());
        return dmat;
    }

    private float kernel(float beta, AbstractVector v1, AbstractVector v2) {
        Euclidean diss = new Euclidean();
        return (float)Math.exp(-beta * diss.calculate(v1, v2));
    }
}

