/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.kernel;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.kernel.KernelDistance;
import simpletree.matrix.AbstractMatrix;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Distance.Technique", name="Kernel Distance", description="Create a distance matrix calculated using the Mahalanobis approach.")
public class KernelDistanceComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;

    public void execute() throws IOException {
        if (this.matrix == null) {
            throw new IOException("A points matrix should be provided.");
        }
        KernelDistance kd = new KernelDistance();
        this.dmat = kd.transform(this.matrix);
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public DistanceMatrix output() {
        return this.dmat;
    }

    public AbstractParametersView getParametersEditor() {
        return null;
    }

    public void reset() {
        this.matrix = null;
        this.dmat = null;
    }
}

