/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.mahalanobis;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import java.util.Arrays;
import simpletree.distance.DistanceMatrix;
import simpletree.matrix.AbstractMatrix;

public class Mahalanobis {
    public DistanceMatrix getDistanceMatrix(AbstractMatrix matrix) {
        float[][] points = matrix.toMatrix();
        DoubleMatrix2D cov = this.createCovarianceMatrix(points);
        DoubleMatrix2D identity = DoubleFactory2D.sparse.identity(points[0].length);
        CholeskyDecomposition chol = new CholeskyDecomposition(cov);
        DoubleMatrix2D cov_inverse = chol.solve(identity);
        DistanceMatrix dmat = new DistanceMatrix(matrix.getRowCount());
        for (int i = 1; i < matrix.getRowCount(); ++i) {
            for (int j = 0; j < i; ++j) {
                DoubleMatrix1D diff = DoubleFactory1D.sparse.make(points[0].length);
                float[] vect1 = matrix.getRow(i).toArray();
                float[] vect2 = matrix.getRow(j).toArray();
                for (int k = 0; k < vect1.length; ++k) {
                    diff.setQuick(k, (double)(vect1[k] - vect2[k]));
                }
                DoubleMatrix1D diff_cinv = DoubleFactory1D.sparse.make(points[0].length);
                for (int k = 0; k < points[0].length; ++k) {
                    double zDotProduct = cov_inverse.viewColumn(k).zDotProduct(diff);
                    diff_cinv.setQuick(k, zDotProduct);
                }
                double dist = diff.zDotProduct(diff_cinv);
                dmat.setDistance(i, j, (float)Math.sqrt(dist));
            }
        }
        dmat.setClassData(matrix.getClassData());
        dmat.setIds(matrix.getIds());
        return dmat;
    }

    private DoubleMatrix2D createCovarianceMatrix(float[][] points) {
        int i;
        int j;
        int i2;
        double[] mean = new double[points[0].length];
        Arrays.fill(mean, 0.0);
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j = 0; j < points[i2].length; ++j) {
                int n = j;
                mean[n] = mean[n] + (double)points[i2][j];
            }
        }
        i2 = 0;
        while (i2 < mean.length) {
            int n = i2++;
            mean[n] = mean[n] / (double)points.length;
        }
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j = 0; j < points[i2].length; ++j) {
                float[] fArray = points[i2];
                int n = j;
                fArray[n] = (float)((double)fArray[n] - mean[j]);
            }
        }
        double[][] covmatrix = new double[points[0].length][];
        for (i = 0; i < covmatrix.length; ++i) {
            covmatrix[i] = new double[points[0].length];
        }
        for (i = 0; i < covmatrix.length; ++i) {
            for (int j2 = 0; j2 < covmatrix.length; ++j2) {
                covmatrix[i][j2] = this.covariance(points, i, j2);
            }
        }
        return new DenseDoubleMatrix2D((double[][])covmatrix);
    }

    private float covariance(float[][] points, int a, int b) {
        float cov = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            cov += points[i][a] * points[i][b];
        }
        return cov /= (float)points.length;
    }
}

