/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.similaritymatrix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.similaritymatrix.SimilarityMatrixInstance;
import simpletree.distance.similaritymatrix.SimilarityMatrixModel;
import simpletree.matrix.AbstractMatrix;

public class SimilarityMatrixCreation {
    public SimilarityMatrixModel execute(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.execute(dmat);
    }

    public SimilarityMatrixModel execute(DistanceMatrix dmat) throws IOException {
        SimilarityMatrixModel model = new SimilarityMatrixModel();
        int[] index = this.createIndex(dmat);
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            SimilarityMatrixInstance smi = new SimilarityMatrixInstance(model, dmat.getLabels().get(index[i]), dmat.getIds().get(index[i]), i, dmat.getClassData()[index[i]]);
            float[] distances = new float[dmat.getElementCount()];
            for (int j = 0; j < distances.length; ++j) {
                distances[j] = dmat.getDistance(index[i], index[j]);
            }
            smi.setDistancesToInstances(distances);
        }
        return model;
    }

    private int[] createIndex(DistanceMatrix dmat) {
        int[] index_aux = new int[dmat.getElementCount()];
        float[] cdata = dmat.getClassData();
        ArrayList<Float> classes = new ArrayList<Float>();
        for (int i = 0; i < cdata.length; ++i) {
            if (classes.contains(Float.valueOf(cdata[i]))) continue;
            classes.add(Float.valueOf(cdata[i]));
        }
        Collections.sort(classes);
        int n = 0;
        int ini = 0;
        for (int i = 0; i < classes.size(); ++i) {
            int j;
            float klass = ((Float)classes.get(i)).floatValue();
            for (int j2 = 0; j2 < cdata.length; ++j2) {
                if (cdata[j2] != klass) continue;
                index_aux[n] = j2;
                ++n;
            }
            Object[] indexes = new Pair[n - ini];
            int pivot = 0;
            float max = Float.NEGATIVE_INFINITY;
            for (j = 0; j < indexes.length; ++j) {
                for (int k = indexes.length - 1; k >= 0; --k) {
                    float distance = dmat.getDistance(index_aux[j + ini], index_aux[k + ini]);
                    if (!(max < distance)) continue;
                    pivot = j + ini;
                    max = distance;
                }
            }
            for (j = 0; j < indexes.length; ++j) {
                indexes[j] = new Pair(index_aux[j + ini], dmat.getDistance(index_aux[pivot], index_aux[j + ini]));
            }
            Arrays.sort(indexes);
            for (j = 0; j < indexes.length; ++j) {
                index_aux[j + ini] = ((Pair)indexes[j]).index;
            }
            ini = n;
        }
        ArrayList<Order> order_aux = new ArrayList<Order>();
        Order ord1 = new Order();
        ord1.begin = 0;
        ord1.end = 0;
        ord1.value = 0.0f;
        order_aux.add(ord1);
        for (int j = ord1.begin + 1; j < index_aux.length; ++j) {
            if (cdata[index_aux[ord1.begin]] == cdata[index_aux[j]]) continue;
            ord1.end = j - 1;
            break;
        }
        Order prev_aux = ord1;
        while (prev_aux.end < index_aux.length - 1) {
            Order new_ord = new Order();
            new_ord.begin = prev_aux.end + 1;
            new_ord.end = prev_aux.end + 1;
            new_ord.value = 0.0f;
            order_aux.add(new_ord);
            for (int j = new_ord.begin + 1; j < index_aux.length; ++j) {
                if (cdata[index_aux[new_ord.begin]] == cdata[index_aux[j]] && j != index_aux.length - 1) continue;
                new_ord.end = j - 1;
                if (j == index_aux.length - 1) {
                    new_ord.end = j;
                }
                new_ord.value = dmat.getDistance(index_aux[ord1.end], index_aux[new_ord.begin]);
                break;
            }
            prev_aux = new_ord;
        }
        Collections.sort(order_aux);
        int[] index = new int[index_aux.length];
        int k = 0;
        for (int i = 0; i < order_aux.size(); ++i) {
            Order ord2 = (Order)order_aux.get(i);
            int j = ord2.begin;
            while (j <= ord2.end) {
                index[k] = index_aux[j];
                ++j;
                ++k;
            }
        }
        return index;
    }

    class Pair
    implements Comparable {
        public static final float EPSILON = 1.0E-5f;
        public int index;
        public float value;

        public Pair(int index, float value) {
            this.index = index;
            this.value = value;
        }

        public int compareTo(Object o) {
            if (o instanceof Pair) {
                if (this.value - ((Pair)o).value == 1.0E-5f) {
                    return 0;
                }
                if (this.value - ((Pair)o).value > 1.0E-5f) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
    }

    class Order
    implements Comparable {
        public static final float EPSILON = 1.0E-5f;
        public int begin;
        public int end;
        public float value;

        Order() {
        }

        public int compareTo(Object o) {
            if (o instanceof Order) {
                if (Math.abs(this.value - ((Order)o).value) == 1.0E-5f) {
                    return 0;
                }
                if (this.value - ((Order)o).value > 1.0E-5f) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
    }
}

