/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.similaritymatrix;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.distance.similaritymatrix.SimilarityMatrixModelComp;
import vispipelinebasics.interfaces.AbstractParametersView;

public class SimilarityMatrixCreationParamView
extends AbstractParametersView {
    private SimilarityMatrixModelComp comp;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JPanel parametersPanel;

    public SimilarityMatrixCreationParamView(SimilarityMatrixModelComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(disstype);
        }
        this.reset();
    }

    private void initComponents() {
        this.parametersPanel = new JPanel();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.setLayout(new BorderLayout());
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("Similarity Matrix Parameters"));
        this.parametersPanel.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.parametersPanel.add((Component)this.dissimilarityPanel, gridBagConstraints);
        this.add(this.parametersPanel, "Center");
    }

    public void reset() {
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        }
    }

    public void finished() throws IOException {
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
    }
}

