/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.cluster;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.clustering.Clustering;
import simpletree.datamining.clustering.multiscale.MultiscaleClustering;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.cluster.TreeMultilevelClustering;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;

public class TreeClusterFile {
    private float version = 1.4f;
    private String inputMatrixName = "";
    private int elementCount;
    private int dimensionality;
    private String dissName = "";
    private String clusTechnique = "";
    private String clusParams = "";
    private Map<Integer, Long> clusterMap = new HashMap<Integer, Long>();
    private String fileName = "";
    private long start = 0L;
    private long end = 0L;

    public TreeClusterFile(String _fileName) {
        this.fileName = _fileName;
    }

    private void writeHeader(RandomAccessFile out) throws IOException {
        out.writeFloat(this.version);
        out.writeInt(this.getElementCount());
        out.writeInt(this.getDimensionality());
        out.writeInt(this.getInputMatrixName().length());
        out.writeBytes(this.getInputMatrixName());
        out.writeInt(this.getDissName().length());
        out.writeBytes(this.getDissName());
        out.writeInt(this.getClusteringTechnique().length());
        out.writeBytes(this.getClusteringTechnique());
        out.writeInt(this.getClusteringParams().length());
        out.writeBytes(this.getClusteringParams());
    }

    public void readHeader() throws FileNotFoundException, IOException {
        File file = new File(this.fileName);
        RandomAccessFile in = new RandomAccessFile(file, "r");
        in.seek(this.start);
        this.readHeader(in);
        long filePosition = in.getFilePointer();
        in.close();
    }

    public void readHeader(RandomAccessFile in) throws IOException {
        this.version = in.readFloat();
        this.setElementCount(in.readInt());
        this.setDimensionality(in.readInt());
        int inputFileSize = in.readInt();
        byte[] inputFileBytes = new byte[inputFileSize];
        in.read(inputFileBytes);
        this.setInputMatrixName(new String(inputFileBytes));
        int dissNameSize = in.readInt();
        byte[] dissNameBytes = new byte[dissNameSize];
        in.read(dissNameBytes);
        this.setDissName(new String(dissNameBytes));
        int clusTechSize = in.readInt();
        byte[] clusTechBytes = new byte[clusTechSize];
        in.read(clusTechBytes);
        this.setClusteringTechnique(new String(clusTechBytes));
        int clusParamsSize = in.readInt();
        byte[] clusParamsBytes = new byte[clusParamsSize];
        in.read(clusParamsBytes);
        this.setClusteringParams(new String(clusParamsBytes));
    }

    public void write(TreeCluster cluster) throws FileNotFoundException, IOException {
        this.clusterMap = new HashMap<Integer, Long>();
        try (RandomAccessFile out = new RandomAccessFile(this.fileName, "rw");){
            out.seek(this.start);
            this.writeHeader(out);
            this.writeCluster(out, cluster, true);
            this.writeFileMap(out);
        }
    }

    private void writeFileMap(RandomAccessFile out) throws FileNotFoundException, IOException {
        long mapFilePosition = out.getFilePointer();
        for (Map.Entry<Integer, Long> e : this.clusterMap.entrySet()) {
            int clusterId = e.getKey();
            long mapPosition = e.getValue();
            out.writeInt(clusterId);
            out.writeLong(mapPosition);
        }
        out.writeInt(this.clusterMap.size());
        out.writeLong(mapFilePosition);
        this.end = out.getFilePointer();
    }

    public void readFileMap(RandomAccessFile in) throws FileNotFoundException, IOException {
        this.clusterMap = new HashMap<Integer, Long>();
        long endFile = this.end == 0L ? in.length() : this.end;
        in.seek(endFile - 8L - 4L);
        int listSize = in.readInt();
        long fileMapPosition = in.readLong();
        in.seek(fileMapPosition);
        byte[] buffer = new byte[12 * listSize];
        in.read(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        for (int i = 0; i < listSize; ++i) {
            int clusterId = byteBuffer.getInt();
            long position = byteBuffer.getLong();
            this.clusterMap.put(clusterId, position);
        }
    }

    private void writeCluster(RandomAccessFile out, TreeCluster cluster, boolean writeSubClusters) throws IOException {
        this.clusterMap.put(cluster.getId(), out.getFilePointer());
        out.writeInt(cluster.getId());
        out.writeInt(cluster.type.getValue());
        out.writeInt(cluster.getLevelHeight());
        if (cluster.type == TreeCluster.ClusterType.LEAF) {
            out.writeInt(cluster.getSize());
            for (Integer elementId : cluster.getItemList()) {
                out.writeInt(elementId);
            }
        } else {
            int i;
            out.writeInt(cluster.getSubClusterList().size());
            for (i = 0; i < cluster.getSubClusterList().size(); ++i) {
                out.writeInt(cluster.getSubClusterList().get(i).getId());
            }
            for (i = 0; i < cluster.getSubClusterList().size(); ++i) {
                out.writeInt(cluster.getSubClusterList().get(i).getSize());
            }
            for (i = 0; i < cluster.getSubClusterList().size(); ++i) {
                out.writeInt(cluster.getSubClusterList().get(i).getLevelHeight());
            }
            for (i = 0; i < cluster.getSubClusterList().size(); ++i) {
                out.writeInt(cluster.getSubClusterList().get(i).getMedoidList().get(0));
            }
        }
        out.writeInt(cluster.getParentId());
        out.writeInt(cluster.getMedoidList().size());
        for (Integer medoid : cluster.getMedoidList()) {
            out.writeInt(medoid);
        }
        out.writeInt(cluster.getNewick().length());
        out.writeBytes(cluster.getNewick());
        if (writeSubClusters) {
            for (TreeCluster subCluster : cluster.getSubClusterList()) {
                this.writeCluster(out, subCluster, true);
            }
        }
    }

    public TreeCluster readAll() throws IOException {
        File file = new File(this.fileName);
        RandomAccessFile in = new RandomAccessFile(file, "r");
        this.readHeader();
        if (this.clusterMap.isEmpty()) {
            this.readFileMap(in);
        }
        in.seek(this.start);
        byte[] fileContent = new byte[(int)this.end - (int)this.start];
        in.read(fileContent);
        ByteBuffer bb = ByteBuffer.wrap(fileContent);
        this.version = bb.getFloat();
        this.elementCount = bb.getInt();
        this.dimensionality = bb.getInt();
        int inputFileSize = bb.getInt();
        byte[] inputFileBytes = new byte[inputFileSize];
        bb.get(inputFileBytes);
        this.inputMatrixName = new String(inputFileBytes);
        int dissNameSize = bb.getInt();
        byte[] dissNameBytes = new byte[dissNameSize];
        bb.get(dissNameBytes);
        this.dissName = new String(dissNameBytes);
        int clusTechSize = bb.getInt();
        byte[] clusTechBytes = new byte[clusTechSize];
        bb.get(clusTechBytes);
        this.clusTechnique = new String(clusTechBytes);
        int clusParamsSize = bb.getInt();
        byte[] clusParamsBytes = new byte[clusParamsSize];
        bb.get(clusParamsBytes);
        this.clusParams = new String(clusParamsBytes);
        int bufferPosition = bb.position();
        TreeCluster rootCluster = this.readClusterRecursive(this.elementCount, bb);
        return rootCluster;
    }

    private TreeCluster readClusterRecursive(int clusterId, ByteBuffer bb) {
        long position = this.clusterMap.get(clusterId);
        bb.position((int)position - (int)this.start);
        TreeCluster cluster = this.readCluster(bb);
        ArrayList<TreeCluster> wholeSubclusterList = new ArrayList<TreeCluster>();
        for (TreeCluster lightSubcluster : cluster.getSubClusterList()) {
            wholeSubclusterList.add(this.readClusterRecursive(lightSubcluster.getId(), bb));
        }
        cluster.setSubClusterList(wholeSubclusterList);
        return cluster;
    }

    private TreeCluster readCluster(ByteBuffer bb) {
        int i;
        int size;
        TreeCluster treeCluster = new TreeCluster(bb.getInt());
        int type = bb.getInt();
        treeCluster.type = type == 0 ? TreeCluster.ClusterType.INTERNAL : TreeCluster.ClusterType.LEAF;
        treeCluster.setLevelHeight(bb.getInt());
        if (treeCluster.type == TreeCluster.ClusterType.LEAF) {
            size = bb.getInt();
            treeCluster.setSize(size);
            List<Integer> items = treeCluster.getItemList();
            for (i = 0; i < size; ++i) {
                items.add(bb.getInt());
            }
        } else {
            size = bb.getInt();
            List<TreeCluster> subclusters = treeCluster.getSubClusterList();
            for (i = 0; i < size; ++i) {
                subclusters.add(new TreeCluster(bb.getInt()));
            }
            int clusterSize = 0;
            int subclusterSize = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                subclusterSize = bb.getInt();
                subclusters.get(i2).setSize(subclusterSize);
                clusterSize += subclusterSize;
            }
            treeCluster.setSize(clusterSize);
            for (int i3 = 0; i3 < size; ++i3) {
                int subclusterHeight = bb.getInt();
                subclusters.get(i3).setLevelHeight(subclusterHeight);
            }
            int firstMedoid = 0;
            for (int i4 = 0; i4 < size; ++i4) {
                firstMedoid = bb.getInt();
                ArrayList<Integer> medoidList = new ArrayList<Integer>();
                medoidList.add(firstMedoid);
                subclusters.get(i4).setMedoidList(medoidList);
            }
        }
        treeCluster.setParentId(bb.getInt());
        int medoidsCount = bb.getInt();
        List<Integer> medoids = treeCluster.getMedoidList();
        for (i = 0; i < medoidsCount; ++i) {
            medoids.add(bb.getInt());
        }
        byte[] newickBytes = new byte[bb.getInt()];
        bb.get(newickBytes);
        treeCluster.setNewick(new String(newickBytes));
        return treeCluster;
    }

    public TreeCluster read(int clusterId, RandomAccessFile in) throws IOException {
        int i;
        int size;
        if (this.clusterMap.isEmpty()) {
            this.readHeader(in);
            this.readFileMap(in);
        }
        if (!this.clusterMap.containsKey(clusterId)) {
            return null;
        }
        in.seek(this.clusterMap.get(clusterId));
        TreeCluster treeCluster = new TreeCluster(in.readInt());
        int type = in.readInt();
        treeCluster.type = type == 0 ? TreeCluster.ClusterType.INTERNAL : TreeCluster.ClusterType.LEAF;
        treeCluster.setLevelHeight(in.readInt());
        if (treeCluster.type == TreeCluster.ClusterType.LEAF) {
            size = in.readInt();
            treeCluster.setSize(size);
            List<Integer> items = treeCluster.getItemList();
            for (i = 0; i < size; ++i) {
                items.add(in.readInt());
            }
        } else {
            size = in.readInt();
            List<TreeCluster> subclusters = treeCluster.getSubClusterList();
            for (i = 0; i < size; ++i) {
                subclusters.add(new TreeCluster(in.readInt()));
            }
            int clusterSize = 0;
            int subclusterSize = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                subclusterSize = in.readInt();
                subclusters.get(i2).setSize(subclusterSize);
                clusterSize += subclusterSize;
            }
            treeCluster.setSize(clusterSize);
            for (int i3 = 0; i3 < size; ++i3) {
                int subclusterHeight = in.readInt();
                subclusters.get(i3).setLevelHeight(subclusterHeight);
            }
            int firstMedoid = 0;
            for (int i4 = 0; i4 < size; ++i4) {
                firstMedoid = in.readInt();
                ArrayList<Integer> medoidList = new ArrayList<Integer>();
                medoidList.add(firstMedoid);
                subclusters.get(i4).setMedoidList(medoidList);
            }
        }
        treeCluster.setParentId(in.readInt());
        int medoidsCount = in.readInt();
        List<Integer> medoids = treeCluster.getMedoidList();
        for (i = 0; i < medoidsCount; ++i) {
            medoids.add(in.readInt());
        }
        byte[] newickBytes = new byte[in.readInt()];
        in.read(newickBytes);
        treeCluster.setNewick(new String(newickBytes));
        in.close();
        return treeCluster;
    }

    public TreeCluster read(int clusterId) throws IOException {
        File file = new File(this.fileName);
        RandomAccessFile in = new RandomAccessFile(file, "r");
        in.seek(this.start);
        return this.read(clusterId, in);
    }

    private static void testWriting() throws IOException, Exception {
        long initTime = System.currentTimeMillis();
        System.out.println("[TreeCusterFile] Starting writing...");
        AbstractMatrix matrix = MatrixFactory.getInstance("/home/renato/corel1000.data");
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        Clustering technique = MultiscaleClustering.getClusteringTechnique(0, "20", diss, matrix);
        TreeMultilevelClustering clus = new TreeMultilevelClustering();
        TreeCluster clusterRoot = clus.clusterize(matrix, technique, diss, 40, false, 10);
        TreeClusterFile file = new TreeClusterFile("/home/renato/corel1000Tree.clus");
        file.setInputMatrixName("ImagensCorel.data");
        file.setDissName(DissimilarityFactory.DissimilarityType.EUCLIDEAN.name());
        file.setDimensionality(matrix.getDimensions());
        file.setElementCount(matrix.getRowCount());
        file.setClusteringTechnique("K-Means");
        file.setClusteringParams("20");
        file.write(clusterRoot);
        System.out.println("[TreeClusterFile] Writing ended.");
        System.out.println("[TreeClusterFile] Time spent: " + (System.currentTimeMillis() - initTime) / 1000L + "s");
    }

    private static void testReading() throws IOException {
        long initTime = System.currentTimeMillis();
        System.out.println("[TreeCusterFile] Start reading a cluster...");
        TreeClusterFile file = new TreeClusterFile("/home/renato/corel1000Tree.clus");
        file.readHeader();
        TreeCluster rootCluster = file.read(file.getElementCount());
        System.out.println("[TreeClusterFile] Reading ended.");
        System.out.println("[TreeClusterFile] Time spent: " + (System.currentTimeMillis() - initTime) / 1000L + "s");
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, Exception {
        TreeClusterFile.testWriting();
        TreeClusterFile.testReading();
    }

    public String getInputMatrixName() {
        return this.inputMatrixName;
    }

    public void setInputMatrixName(String inputMatrixName) {
        this.inputMatrixName = inputMatrixName;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public void setElementCount(int elementCount) {
        this.elementCount = elementCount;
    }

    public int getDimensionality() {
        return this.dimensionality;
    }

    public void setDimensionality(int dimensionality) {
        this.dimensionality = dimensionality;
    }

    public String getDissName() {
        return this.dissName;
    }

    public void setDissName(String dissName) {
        this.dissName = dissName;
    }

    public String getClusteringTechnique() {
        return this.clusTechnique;
    }

    public void setClusteringTechnique(String clusTechnique) {
        this.clusTechnique = clusTechnique;
    }

    public String getClusteringParams() {
        return this.clusParams;
    }

    public void setClusteringParams(String clusParams) {
        this.clusParams = clusParams;
    }

    public List<Integer> getClustersIds() {
        List clustersIds = null;
        try {
            if (this.clusterMap.isEmpty()) {
                File file = new File(this.fileName);
                RandomAccessFile in = new RandomAccessFile(file, "r");
                in.seek(this.start);
                this.readHeader(in);
                this.readFileMap(in);
            }
            for (Integer key : this.clusterMap.keySet()) {
                clustersIds.add(key);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TreeClusterFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TreeClusterFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        return clustersIds;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }
}

