/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.cluster;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;
import simpletree.datamining.clustering.BKmeans;
import simpletree.datamining.clustering.Clustering;
import simpletree.datamining.clustering.HierarchicalClustering;
import simpletree.datamining.clustering.Jdbscan2D;
import simpletree.datamining.clustering.Kmeans;
import simpletree.datamining.clustering.Kmedoids;
import simpletree.datamining.clustering.isodata.Group;
import simpletree.datamining.clustering.isodata.IsoData;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.io.cluster.DistanceElementPair;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.tree.NeighborJoining;
import simpletree.io.tree.NewickConversor;
import simpletree.io.tree.Node;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseVector;

public class TreeMultilevelClustering {
    private Logger logger = Logger.getLogger(MatrixFactory.class.getName());
    private int nrMedoids = 5;
    private AbstractDissimilarity diss;
    private int maxId = 1;
    private int totalElementCount;
    private int currentElementCount;
    private long initTime;
    private int clusteringLevel;
    public static final int CLUSTER_OK = 0;
    public static final int CLUSTER_SIZE_ERROR = 1;
    public static final int CLUSTER_ITEM_INDEX_ERROR = 2;
    public static final int CLUSTER_MEDOID_INDEX_ERROR = 4;

    public TreeCluster clusterize(AbstractMatrix dataMatrix, Clustering clusteringTechnique, AbstractDissimilarity dissimilarity, int maxClusterSize, boolean clustersFromClasses, int numMedoids) throws IOException {
        this.clusteringLevel = 0;
        this.nrMedoids = numMedoids;
        this.diss = dissimilarity;
        this.totalElementCount = dataMatrix.getRowCount();
        this.maxId = dataMatrix.getRowCount() + 1;
        this.initTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date(this.initTime);
        System.out.println("[" + sdf.format(date) + "] Beginning multiscale clustering...");
        ArrayList<TreeCluster> clusterList = this.getClustersRecursive(dataMatrix, clusteringTechnique, this.diss, maxClusterSize, clustersFromClasses);
        for (TreeCluster cluster : clusterList) {
            AbstractMatrix clusterMatrix = cluster.getSubMatrix(dataMatrix);
            date = new Date(System.currentTimeMillis());
            System.out.printf("[" + sdf.format(date) + "] Getting Cluster %d medoids...\n", cluster.getId());
            ArrayList<Integer> newMedoidList = this.processMedoidsRecursive(cluster, dataMatrix);
            cluster.setMedoidList(newMedoidList);
            date = new Date(System.currentTimeMillis());
            System.out.printf("[" + sdf.format(date) + "]Syncing subclusters indices (elements and medoids)...\n", new Object[0]);
            for (TreeCluster subCluster : cluster.getSubClusterList()) {
                this.syncClusterIds(subCluster, clusterMatrix, dataMatrix);
            }
        }
        TreeCluster rootCluster = new TreeCluster(dataMatrix.getRowCount());
        rootCluster.setParentId(rootCluster.getId());
        rootCluster.setSubClusterList(clusterList);
        rootCluster.type = TreeCluster.ClusterType.INTERNAL;
        int rootSize = 0;
        float[] rootCentroid = new float[dataMatrix.getDimensions()];
        ArrayList<Integer> rootMedoidList = new ArrayList<Integer>();
        for (int i = 0; i < clusterList.size(); ++i) {
            TreeCluster subCluster;
            subCluster = (TreeCluster)clusterList.get(i);
            rootSize += subCluster.getSize();
            rootMedoidList.add(subCluster.getMedoidList().get(0));
            float[] subclusterCentroid = subCluster.getCentroidVector().getValues();
            for (int j = 0; j < rootCentroid.length; ++j) {
                int n = j;
                rootCentroid[n] = rootCentroid[n] + subclusterCentroid[j];
            }
        }
        for (int j = 0; j < rootCentroid.length; ++j) {
            rootCentroid[j] = rootCentroid[j] / (float)clusterList.size();
        }
        rootCluster.setSize(rootSize);
        rootCluster.setCentroidVector(new DenseVector(rootCentroid));
        rootCluster.setMedoidList(rootMedoidList);
        this.maxId = dataMatrix.getRowCount() * 2;
        this.processNewickRecursive(rootCluster, dataMatrix, dissimilarity);
        long endTime = System.currentTimeMillis();
        date = new Date(endTime);
        System.out.println(sdf.format(date) + " Finished multiscale clustering...");
        System.out.println("The process took " + (float)(endTime - this.initTime) / 1000.0f + " seconds.");
        return rootCluster;
    }

    private void processNewickRecursive(TreeCluster cluster, AbstractMatrix matrix, AbstractDissimilarity diss) {
        cluster.setNewick(this.createNewickTree(cluster, matrix, diss));
        for (TreeCluster subCluster : cluster.getSubClusterList()) {
            this.processNewickRecursive(subCluster, matrix, diss);
        }
    }

    private String createNewickTree(TreeCluster cluster, AbstractMatrix matrix, AbstractDissimilarity diss) {
        String newick;
        System.out.println("Newick for cluster " + cluster.getId());
        if (cluster.getSubClusterList().isEmpty()) {
            AbstractMatrix clusterMatrix = cluster.getSubMatrix(matrix);
            NeighborJoining nj = new NeighborJoining();
            nj.setNextVirtualId(this.maxId);
            Node rootNode = nj.execute(clusterMatrix, diss);
            this.maxId = nj.getNextVirtualId();
            newick = NewickConversor.buildString(rootNode);
        } else {
            DistanceMatrix distMat = this.buildCentroidsDM(cluster.getSubClusterList(), diss);
            NeighborJoining nj = new NeighborJoining();
            nj.setNextVirtualId(this.maxId);
            Node rootNode = nj.execute(distMat);
            this.maxId = nj.getNextVirtualId();
            newick = NewickConversor.buildString(rootNode);
        }
        return newick;
    }

    private DistanceMatrix buildCentroidsDM(List<TreeCluster> clusterList, AbstractDissimilarity diss) {
        DistanceMatrix dmCentroids = new DistanceMatrix(clusterList.size());
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < clusterList.size(); ++i) {
            ids.add(clusterList.get(i).getId());
            for (int j = i + 1; j < clusterList.size(); ++j) {
                DenseVector vectorA = clusterList.get(i).getCentroidVector();
                DenseVector vectorB = clusterList.get(j).getCentroidVector();
                float distance = diss.calculate(vectorA, vectorB);
                dmCentroids.setDistance(i, j, distance);
            }
        }
        dmCentroids.setIds(ids);
        return dmCentroids;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<TreeCluster> getClustersRecursive(AbstractMatrix matrix, Clustering clusteringTechnique, AbstractDissimilarity diss, int maxClusterSize, boolean clustersFromClasses) throws IOException {
        void var9_16;
        ArrayList<Object> clusters = new ArrayList();
        if (clustersFromClasses) {
            System.out.printf("[Clustering Level %d] Getting classes as clusters...\n", this.clusteringLevel);
            ArrayList<Float> klasses = new ArrayList<Float>();
            for (int i = 0; i < matrix.getRowCount(); ++i) {
                AbstractVector abstractVector = matrix.getRow(i);
                if (!klasses.contains(Float.valueOf(abstractVector.getKlass()))) {
                    clusters.add(new ArrayList());
                    klasses.add(Float.valueOf(abstractVector.getKlass()));
                }
                ((ArrayList)clusters.get(klasses.indexOf(Float.valueOf(abstractVector.getKlass())))).add(i);
            }
        } else if (clusteringTechnique instanceof Jdbscan2D) {
            clusters = clusteringTechnique.execute(diss, matrix);
            float eps = ((Jdbscan2D)clusteringTechnique).getEps();
            while (clusters == null || clusters.size() < 2) {
                System.out.println("DBScan clustering (EPS = " + eps + ") generated a single cluster. Trying with eps = " + (eps - 0.1f));
                clusteringTechnique = new Jdbscan2D(eps -= 0.01f);
                clusters = clusteringTechnique.execute(diss, matrix);
            }
        } else {
            System.out.printf("[Clustering Level %d] Clustering " + matrix.getRowCount() + " elements...", this.clusteringLevel);
            clusters = clusteringTechnique.execute(diss, matrix);
            System.out.println(" finished!");
        }
        int clustersElementsCount = 0;
        for (ArrayList arrayList : clusters) {
            clustersElementsCount += arrayList.size();
        }
        if (clustersElementsCount != matrix.getRowCount()) {
            matrix.save("matrizErro.data");
            System.err.println("Erro!! Resultado do clustering retorna numero de elementos diferente da matriz original!!");
            System.err.printf("Matrix original = %d, Resultado Clustering = %d\n", matrix.getRowCount(), clustersElementsCount);
            System.exit(0);
        }
        ArrayList<TreeCluster> clusterList = new ArrayList<TreeCluster>();
        boolean bl = false;
        while (var9_16 < clusters.size()) {
            TreeCluster cluster = new TreeCluster(this.maxId + 1);
            ++this.maxId;
            ArrayList<Integer> clusterElements = new ArrayList<Integer>();
            clusterElements.addAll((Collection)clusters.get((int)var9_16));
            cluster.setItemList(clusterElements);
            cluster.setSize(clusterElements.size());
            clusterList.add(cluster);
            ++var9_16;
        }
        for (TreeCluster cluster : clusterList) {
            if (cluster.getSize() > maxClusterSize) {
                AbstractMatrix clusterPoints = cluster.getSubMatrix(matrix);
                ++this.clusteringLevel;
                ArrayList<TreeCluster> subClusterList = this.getClustersRecursive(clusterPoints, clusteringTechnique, diss, maxClusterSize, false);
                --this.clusteringLevel;
                cluster.setSubClusterList(subClusterList);
                int maxHeight = 0;
                for (TreeCluster subCluster : subClusterList) {
                    subCluster.setParentId(cluster.getId());
                    if (maxHeight >= subCluster.getLevelHeight()) continue;
                    maxHeight = subCluster.getLevelHeight();
                }
                cluster.setLevelHeight(maxHeight + 1);
                cluster.type = TreeCluster.ClusterType.INTERNAL;
                continue;
            }
            cluster.type = TreeCluster.ClusterType.LEAF;
            this.currentElementCount += cluster.getSize();
            float progress = (float)this.currentElementCount / (float)this.totalElementCount * 100.0f;
            System.out.printf("[Clustering Level %d] Progress: %d/%d elements processed... %d%%\n", this.clusteringLevel, this.currentElementCount, this.totalElementCount, (int)progress);
        }
        return clusterList;
    }

    private int getBestMedoid(List<Integer> medoidList, AbstractMatrix matrix) {
        TreeMap<Float, Integer> medoidDistanceMap = new TreeMap<Float, Integer>();
        DenseVector vector = this.getClusterCentroid(matrix, medoidList);
        for (Integer i : medoidList) {
            AbstractVector vector2 = matrix.getRow(i);
            float distance = this.diss.calculate(vector, vector2);
            medoidDistanceMap.put(Float.valueOf(distance), i);
        }
        return (Integer)medoidDistanceMap.get(medoidDistanceMap.firstKey());
    }

    private ArrayList<Integer> processMedoidsRecursive(TreeCluster cluster, AbstractMatrix upperLevelMatrix) throws IOException {
        ++this.clusteringLevel;
        DenseVector centroidVector = this.getClusterCentroid(upperLevelMatrix, cluster.getItemList());
        cluster.setCentroidVector(centroidVector);
        ArrayList<Integer> newMedoidList = new ArrayList<Integer>();
        if (cluster.getSubClusterList().isEmpty()) {
            DenseVector clusterCentroid = this.getClusterCentroid(upperLevelMatrix, cluster.getItemList());
            newMedoidList = this.getClusterMedoids(this.nrMedoids, upperLevelMatrix, this.diss, clusterCentroid, cluster.getItemList());
            cluster.setMedoidList(newMedoidList);
        } else {
            AbstractMatrix clusterMatrix = cluster.getSubMatrix(upperLevelMatrix);
            for (TreeCluster subCluster : cluster.getSubClusterList()) {
                ArrayList<Integer> newSubClusterMedoids = this.processMedoidsRecursive(subCluster, clusterMatrix);
                int subClusterMedoid = this.getBestMedoid(newSubClusterMedoids, clusterMatrix);
                ArrayList<Integer> newSubClusterMedoidList = new ArrayList<Integer>();
                newSubClusterMedoidList.add(subClusterMedoid);
                AbstractMatrix subClusterMatrix = subCluster.getSubMatrix(clusterMatrix);
                this.syncItemsIds(newSubClusterMedoidList, clusterMatrix, upperLevelMatrix);
                subClusterMedoid = newSubClusterMedoidList.get(0);
                newMedoidList.add(subClusterMedoid);
            }
            cluster.setMedoidList(newMedoidList);
        }
        --this.clusteringLevel;
        return newMedoidList;
    }

    private void syncItemsIds(List<Integer> idsList, AbstractMatrix currMatrix, AbstractMatrix originalMatrix) {
        for (int i = 0; i < idsList.size(); ++i) {
            AbstractVector pointCurrMatrix = currMatrix.getRow(idsList.get(i));
            int originalMatrixRow = this.getMatrixRow(pointCurrMatrix, originalMatrix);
            idsList.set(i, originalMatrixRow);
        }
    }

    private int getMatrixRow(AbstractVector vector, AbstractMatrix matrix) {
        int matrixRow = -1;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            if (vector.getId() != matrix.getRow(i).getId()) continue;
            matrixRow = i;
            break;
        }
        return matrixRow;
    }

    private void syncClusterIds(TreeCluster cluster, AbstractMatrix upperLevelMatrix, AbstractMatrix originalMatrix) throws IOException {
        AbstractMatrix clusterMatrix = cluster.getSubMatrix(upperLevelMatrix);
        if (cluster.getMedoidList().size() > 0) {
            this.syncItemsIds(cluster.getMedoidList(), upperLevelMatrix, originalMatrix);
        }
        if (cluster.getItemList().size() > 0) {
            this.syncItemsIds(cluster.getItemList(), upperLevelMatrix, originalMatrix);
        }
        for (TreeCluster subCluster : cluster.getSubClusterList()) {
            this.syncClusterIds(subCluster, clusterMatrix, originalMatrix);
        }
    }

    private DenseVector getClusterCentroid(AbstractMatrix matrix, List<Integer> clusterElements) {
        float[] vector = new float[matrix.getDimensions()];
        for (int j = 0; j < clusterElements.size(); ++j) {
            AbstractVector v = matrix.getRow(clusterElements.get(j));
            if (v == null) continue;
            for (int k = 0; k < v.size(); ++k) {
                int n = k;
                vector[n] = vector[n] + v.getValue(k);
            }
        }
        int k = 0;
        while (k < vector.length) {
            int n = k++;
            vector[n] = vector[n] / (float)clusterElements.size();
        }
        DenseVector centroid = new DenseVector(vector, this.maxId + 1);
        ++this.maxId;
        return centroid;
    }

    private ArrayList<Integer> getClusterMedoids(int nrMedoids, AbstractMatrix clusterMatrix, AbstractDissimilarity diss, AbstractVector centroid, List<Integer> clusterItems) {
        ArrayList<Integer> medoidList = new ArrayList<Integer>();
        ArrayList<DistanceElementPair> medoidDistanceList = new ArrayList<DistanceElementPair>();
        for (Integer clusterItem : clusterItems) {
            AbstractVector itemVector = clusterMatrix.getRow(clusterItem);
            float distance = diss.calculate(centroid, itemVector);
            medoidDistanceList.add(new DistanceElementPair(Float.valueOf(distance), clusterItem));
        }
        Collections.sort(medoidDistanceList, DistanceElementPair.PairComparator);
        Iterator it = medoidDistanceList.iterator();
        for (int medoidListSize = 0; it.hasNext() && medoidListSize < nrMedoids; ++medoidListSize) {
            int nextId = ((DistanceElementPair)it.next()).getElementId();
            medoidList.add(nextId);
        }
        return medoidList;
    }

    public static Clustering getClusteringTechnique(int clusteringType, String clusteringParams, AbstractDissimilarity diss, AbstractMatrix matrix) {
        Clustering clustering = null;
        switch (clusteringType) {
            case 0: {
                clustering = new Kmeans(Integer.parseInt(clusteringParams));
                break;
            }
            case 1: {
                clustering = new BKmeans(Integer.parseInt(clusteringParams));
                break;
            }
            case 2: {
                clustering = new Kmedoids(Integer.parseInt(clusteringParams));
                break;
            }
            case 3: {
                String[] hParams = clusteringParams.split(";");
                int lNumClusters = Integer.parseInt(hParams[0]);
                if (hParams[1].equalsIgnoreCase("Single Link")) {
                    clustering = new HierarchicalClustering(lNumClusters, HierarchicalClustering.HierarchicalClusteringType.SLINK);
                    break;
                }
                if (hParams[1].equalsIgnoreCase("Complete Link")) {
                    clustering = new HierarchicalClustering(lNumClusters, HierarchicalClustering.HierarchicalClusteringType.CLINK);
                    break;
                }
                if (!hParams[1].equalsIgnoreCase("Average Link")) break;
                clustering = new HierarchicalClustering(lNumClusters, HierarchicalClustering.HierarchicalClusteringType.ALINK);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                clustering = new Jdbscan2D();
                break;
            }
            case 7: {
                Group[] groups = new Group[2];
                int idx = 0;
                groups[idx] = new Group(idx);
                groups[idx].setMeanPoint(matrix.getRow(0));
                groups[++idx] = new Group(idx);
                groups[idx].setMeanPoint(matrix.getRow(1));
                ++idx;
                String[] isoParams = clusteringParams.split(";");
                int k = Integer.parseInt(isoParams[0]);
                int minNumThres = Integer.parseInt(isoParams[1]);
                float stdDeviationThres = Float.parseFloat(isoParams[2]);
                float minDistanceThres = Float.parseFloat(isoParams[3]);
                int maxMergeNumsThres = Integer.parseInt(isoParams[4]);
                int maxIters = Integer.parseInt(isoParams[5]);
                clustering = new IsoData(groups, matrix, k, minNumThres, stdDeviationThres, minDistanceThres, maxMergeNumsThres, maxIters, diss);
            }
        }
        return clustering;
    }

    public static int testCluster(TreeCluster cluster, AbstractMatrix matrix) {
        int clusterErrorCode = 0;
        Stack<TreeCluster> clusterStack = new Stack<TreeCluster>();
        clusterStack.add(cluster);
        int totalClusterSize = 0;
        while (!clusterStack.isEmpty()) {
            TreeCluster currentCluster = (TreeCluster)clusterStack.pop();
            if (currentCluster.getSubClusterList() != null && !currentCluster.getSubClusterList().isEmpty() && !currentCluster.getItemList().isEmpty()) {
                clusterErrorCode = 1;
                System.err.printf("[Cluster %d] ItemList should by empty!\n", currentCluster.getId());
            }
            for (TreeCluster subCluster : currentCluster.getSubClusterList()) {
                clusterStack.push(subCluster);
            }
            for (Integer item : currentCluster.getItemList()) {
                if (item < matrix.getRowCount()) continue;
                clusterErrorCode |= 2;
                System.err.printf("[Cluster %d] Item %d doesn't fit matrix rows index!\n", currentCluster.getId(), item);
            }
            for (Integer medoid : currentCluster.getMedoidList()) {
                if (currentCluster.getSubClusterList().isEmpty()) {
                    if (currentCluster.getItemList().indexOf(medoid) == -1) {
                        clusterErrorCode |= 4;
                        System.err.printf("[Cluster %d] Medoid %d isn't in cluster ItemList!\n", currentCluster.getId(), medoid);
                    }
                } else {
                    boolean temErro = true;
                    for (TreeCluster subCluster : currentCluster.getSubClusterList()) {
                        try {
                            if (subCluster.getMedoidList().indexOf(medoid) == -1) continue;
                            temErro = false;
                            break;
                        }
                        catch (IndexOutOfBoundsException ex) {
                            System.err.printf("[Cluster %d] Error getting subClusters medoidList!\n", subCluster.getId());
                            System.err.println(ex.getMessage());
                            temErro = true;
                        }
                    }
                    if (temErro) {
                        clusterErrorCode |= 4;
                        System.err.printf("[Cluster %d] Medoid %d isn't in subClusters MedoidList!\n", currentCluster.getId(), medoid);
                    }
                }
                if (medoid < matrix.getRowCount()) continue;
                clusterErrorCode |= 2;
            }
            totalClusterSize += currentCluster.getItemList().size();
        }
        if (totalClusterSize != cluster.getSize()) {
            clusterErrorCode |= 1;
            System.err.printf("[Cluster %d]: The size of the cluster (%d) doesn't match (%d)", cluster.getId(), cluster.getSize(), totalClusterSize);
        }
        return clusterErrorCode;
    }

    public static void main(String[] args) throws IOException, Exception {
        AbstractMatrix matrix = MatrixFactory.getInstance("/home/renato/corel1000.data");
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        TreeMultilevelClustering clus = new TreeMultilevelClustering();
        Clustering technique = TreeMultilevelClustering.getClusteringTechnique(0, "10", diss, matrix);
        TreeCluster rootCluster = clus.clusterize(matrix, technique, diss, 50, false, 10);
        System.out.println("FIM");
    }
}

