/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.scalar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;

public class TreeScalar {
    private float min = Float.MAX_VALUE;
    private float max = -3.4028235E38f;
    private List<Float> values = new ArrayList<Float>();
    private long start = 0L;
    private long end = 0L;

    public static void main(String[] args) throws IOException {
        AbstractMatrix mat = MatrixFactory.getInstance("/home/renato/corel1000.data");
        TreeScalar scalar = new TreeScalar();
        scalar.extract(mat);
        scalar.save("/home/renato/corel1000.bscalar");
        scalar = new TreeScalar();
        float value = scalar.read(999, "/home/renato/corel1000.bscalar");
    }

    public List<Float> getValues() {
        return this.values;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void set(List<Float> values) {
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        for (Float v : values) {
            if (v.floatValue() > this.max) {
                this.max = v.floatValue();
            }
            if (!(v.floatValue() < this.min)) continue;
            this.min = v.floatValue();
        }
    }

    public float get(int id) {
        if (id > this.values.size() - 1) {
            return Float.NaN;
        }
        return this.values.get(id).floatValue();
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public void extract(AbstractMatrix matrix) {
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        float[] cdata = matrix.getClassData();
        for (int i = 0; i < cdata.length; ++i) {
            this.values.add(Float.valueOf(cdata[i]));
            if (cdata[i] > this.max) {
                this.max = cdata[i];
            }
            if (!(cdata[i] < this.min)) continue;
            this.min = cdata[i];
        }
    }

    public void save(String filename) throws FileNotFoundException, IOException {
        try (RandomAccessFile out = new RandomAccessFile(filename, "rw");){
            out.seek(this.start);
            out.writeInt(this.values.size());
            out.writeFloat(this.min);
            out.writeFloat(this.max);
            for (int i = 0; i < this.values.size(); ++i) {
                out.writeInt(i);
                out.writeFloat(this.values.get(i).floatValue());
            }
            this.end = out.getFilePointer();
        }
    }

    public void load(String filename) throws FileNotFoundException, IOException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        this.values = new ArrayList<Float>();
        try (RandomAccessFile in = new RandomAccessFile(filename, "r");){
            in.seek(this.start);
            int size = in.readInt();
            this.min = in.readFloat();
            this.max = in.readFloat();
            byte[] buffer = new byte[8 * size];
            in.read(buffer);
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            for (int i = 0; i < size; ++i) {
                int id = byteBuffer.getInt();
                float value = byteBuffer.getFloat();
                ids.add(id);
                this.values.add(Float.valueOf(value));
            }
        }
    }

    public float read(int id, String filename) throws FileNotFoundException, IOException {
        float value;
        try (RandomAccessFile in = new RandomAccessFile(filename, "r");){
            in.seek(this.start);
            int size = in.readInt();
            this.min = in.readFloat();
            this.max = in.readFloat();
            in.seek(in.getFilePointer() + (long)(id * 8));
            int readId = in.readInt();
            value = in.readFloat();
        }
        return value;
    }

    public float readMin(String filename) throws FileNotFoundException, IOException {
        float value;
        try (RandomAccessFile in = new RandomAccessFile(filename, "r");){
            in.seek(this.start);
            int size = in.readInt();
            value = in.readFloat();
        }
        return value;
    }

    public float readMax(String filename) throws FileNotFoundException, IOException {
        float value;
        try (RandomAccessFile in = new RandomAccessFile(filename, "r");){
            in.seek(this.start);
            int size = in.readInt();
            in.readFloat();
            value = in.readFloat();
        }
        return value;
    }
}

