/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.topic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.VectorFactory;

public class StopwordsMatrixFilter {
    public static AbstractMatrix filter(AbstractMatrix matrix, List<String> stopwords) {
        try {
            ArrayList<String> allAttributes = matrix.getAttributes();
            int[] indicesToRemove = new int[matrix.getDimensions()];
            for (int i = 0; i < allAttributes.size(); ++i) {
                indicesToRemove[i] = stopwords.indexOf(allAttributes.get(i)) != -1 ? 1 : 0;
            }
            AbstractMatrix filteredMatrix = MatrixFactory.getInstance(matrix.getClass());
            filteredMatrix.setAttributes(matrix.getAttributes());
            ArrayList<String> filteredLabels = new ArrayList();
            filteredLabels = matrix.getLabels();
            filteredMatrix.setLabels(filteredLabels);
            for (int row = 0; row < matrix.getRowCount(); ++row) {
                AbstractVector vector = matrix.getRow(row);
                float[] vectorValues = vector.toArray();
                float[] filteredValues = new float[matrix.getDimensions()];
                Arrays.fill(filteredValues, 0.0f);
                for (int column = 0; column < vectorValues.length; ++column) {
                    filteredValues[column] = indicesToRemove[column] == 1 ? 0.0f : vectorValues[column];
                }
                AbstractVector filteredVector = VectorFactory.getInstance(matrix.getClass(), filteredValues, vector.getId(), vector.getKlass());
                filteredMatrix.addRow(filteredVector);
            }
            return filteredMatrix;
        }
        catch (IOException ex) {
            Logger.getLogger(StopwordsMatrixFilter.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

