/*
 * Decompiled with CFR 0.152.
 */
package simpletree.layout.force;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.model.AbstractInstance;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.util.SimpleTreeUtil;
import simpletree.view.SimpleTreeFrame;

public class ForceDirectLayout
implements Runnable {
    public Strategy strategy = Strategy.ALL;
    private static final float MAX_EDGE_SIZE = 20.0f;
    private static final float MIN_EDGE_SIZE = 5.0f;
    private boolean normalize = true;
    private float max_length;
    private float min_length;
    private ArrayList<Edge> edges;
    private ArrayList<AbstractInstance> instances;
    private SimpleTreeModel model;
    private SimpleTreeFrame frame;
    private Thread relaxer;
    private Rectangle visualizationArea;

    public ForceDirectLayout(SimpleTreeModel model, SimpleTreeFrame frame, Strategy strategy) {
        this.model = model;
        this.frame = frame;
        this.strategy = strategy;
    }

    private Rectangle getVisualizationArea(ArrayList<AbstractInstance> instanceList) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (AbstractInstance abstractInstance : instanceList) {
            SimpleTreeInstance instance = (SimpleTreeInstance)abstractInstance;
            if (minX > (int)instance.getX()) {
                minX = (int)instance.getX();
            }
            if (maxX < (int)instance.getX()) {
                maxX = (int)instance.getX();
            }
            if (minY > (int)instance.getY()) {
                minY = (int)instance.getY();
            }
            if (maxY >= (int)instance.getY()) continue;
            maxY = (int)instance.getY();
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        int i = 0;
        while (this.relaxer == me) {
            this.relax();
            if (i++ % 5 != 0) continue;
            try {
                this.frame.updateImage();
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    synchronized void relax() {
        if (this.edges != null && this.instances != null) {
            int i;
            block12: for (i = 0; i < this.edges.size(); ++i) {
                Edge e = this.edges.get(i);
                SimpleTreeInstance source = this.model.getInstanceById(e.getSource());
                SimpleTreeInstance target = this.model.getInstanceById(e.getTarget());
                if (source == null) {
                    System.err.println("Error! Source vertex " + source + "not found!");
                    continue;
                }
                if (target == null) {
                    System.err.println("Error! Target vertex " + target + "not found!");
                    continue;
                }
                switch (this.strategy) {
                    case VIRTUAL: {
                        if (!source.isValid()) break;
                        continue block12;
                    }
                    case SELECTED: {
                        if (!source.isSelected() || !target.isSelected()) continue block12;
                    }
                }
                float vx = target.getX() - source.getX();
                float vy = target.getY() - source.getY();
                float len = (float)Math.sqrt(vx * vx + vy * vy);
                float edgeLen = e.getWeight();
                edgeLen = edgeLen != -1.0f && this.normalize ? (edgeLen - this.min_length) / (this.max_length - this.min_length) * 15.0f + 5.0f : 20.0f;
                len = len == 0.0f ? 1.0E-4f : len;
                float f = (edgeLen - len) / (len * 3.0f);
                float dx = f * vx;
                float dy = f * vy;
                target.fdata.dx += dx;
                target.fdata.dy += dy;
                source.fdata.dx += -dx;
                source.fdata.dy += -dy;
            }
            block13: for (i = 0; i < this.instances.size(); ++i) {
                SimpleTreeInstance v1 = (SimpleTreeInstance)this.instances.get(i);
                switch (this.strategy) {
                    case VIRTUAL: {
                        if (!v1.isValid()) break;
                        continue block13;
                    }
                    case SELECTED: {
                        if (!v1.isSelected()) continue block13;
                    }
                }
                float dx = 0.0f;
                float dy = 0.0f;
                for (int j = 0; j < this.instances.size(); ++j) {
                    float vy;
                    if (i == j) continue;
                    SimpleTreeInstance v2 = (SimpleTreeInstance)this.instances.get(j);
                    float vx = v1.getX() - v2.getX();
                    float len = vx * vx + (vy = v1.getY() - v2.getY()) * vy;
                    if (len == 0.0f) {
                        dx = (float)((double)dx + Math.random());
                        dy = (float)((double)dy + Math.random());
                        continue;
                    }
                    if (!(len < 10000.0f)) continue;
                    dx += vx / len;
                    dy += vy / len;
                }
                float dlen = dx * dx + dy * dy;
                if (!(dlen > 0.0f)) continue;
                dlen = (float)Math.sqrt(dlen) / 2.0f;
                v1.fdata.dx += dx / dlen;
                v1.fdata.dy += dy / dlen;
            }
            block15: for (i = 0; i < this.instances.size(); ++i) {
                SimpleTreeInstance v = (SimpleTreeInstance)this.instances.get(i);
                switch (this.strategy) {
                    case VIRTUAL: {
                        if (!v.isValid()) break;
                        continue block15;
                    }
                    case SELECTED: {
                        if (!v.isSelected()) continue block15;
                    }
                }
                float x = v.getX() + Math.max(-5.0f, Math.min(5.0f, v.fdata.dx));
                float y = v.getY() + Math.max(-5.0f, Math.min(5.0f, v.fdata.dy));
                v.setX(x);
                v.setY(y);
                v.fdata.dx /= 2.0f;
                v.fdata.dy /= 2.0f;
            }
        }
    }

    public void start(Connectivity connectivity) {
        if (connectivity != null) {
            this.edges = connectivity.getEdges();
            this.instances = this.model.getInstances();
            this.visualizationArea = this.getVisualizationArea(this.instances);
            this.max_length = Float.MIN_VALUE;
            this.min_length = Float.MAX_VALUE;
            for (Edge e : this.edges) {
                if (e.getWeight() > this.max_length) {
                    this.max_length = e.getWeight();
                }
                if (!(e.getWeight() < this.min_length)) continue;
                this.min_length = e.getWeight();
            }
            this.normalize = this.max_length > this.min_length;
            this.relaxer = new Thread(this);
            this.relaxer.start();
        }
    }

    public void stop() {
        this.relaxer = null;
        Rectangle newVisualizationArea = this.getVisualizationArea(this.instances);
        float aspectRatio = (float)newVisualizationArea.width / (float)newVisualizationArea.height;
        this.visualizationArea = SimpleTreeUtil.TransformRectangle(this.visualizationArea, aspectRatio);
        this.model.normalizeVertex(this.visualizationArea);
        this.frame.updateImage();
    }

    public static enum Strategy {
        ALL,
        VIRTUAL,
        SELECTED;

    }
}

