/*
 * Decompiled with CFR 0.152.
 */
package simpletree.layout.radial;

import java.util.ArrayList;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.SimpleTree;
import simpletree.layout.TreeLayout;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.AbstractInstance;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;

public class RadialLayout
implements TreeLayout {
    protected ArrayList<Node> nodes;
    protected Node root;

    @Override
    public AbstractMatrix execute(SimpleTree tree) {
        this.init(tree);
        for (Node node : this.nodes) {
            node.dist = 1.0f / (1.0f + node.dist);
        }
        this.postorderTraversal(this.root);
        this.root.x = 0.0f;
        this.root.y = 0.0f;
        this.root.w = (float)Math.PI * 2;
        this.root.t = 0.0f;
        this.preorderTraversal(this.root);
        DenseMatrix position = new DenseMatrix();
        int size = this.nodes.size();
        for (int i = 0; i < size; ++i) {
            float[] vect = new float[]{this.nodes.get((int)i).x, this.nodes.get((int)i).y};
            ContentSimpleTree node = tree.getNode(i);
            DenseVector vector = new DenseVector(vect, node.getId(), 0.0f);
            position.addRow(vector);
        }
        return position;
    }

    @Override
    public SimpleTreeModel execute(SimpleTreeModel tree) {
        if (!this.init(tree)) {
            return tree;
        }
        for (Node node : this.nodes) {
            node.dist = 1.0f / (1.0f + node.dist);
        }
        this.postorderTraversal(this.root);
        this.root.x = 0.0f;
        this.root.y = 0.0f;
        this.root.w = (float)Math.PI * 2;
        this.root.t = 0.0f;
        this.preorderTraversal(this.root);
        for (Node node : this.nodes) {
            SimpleTreeInstance ti = tree.getInstanceById(node.id);
            if (ti == null) continue;
            ti.setX(node.x);
            ti.setY(node.y);
            ti.reservedAngle = node.w * 57.29578f;
            ti.angleRightBorder = node.t * 57.29578f;
        }
        return tree;
    }

    protected void init(SimpleTree tree) {
        ArrayList<Edge> edges = tree.getEdges();
        int nrinstances = tree.getSize();
        this.nodes = new ArrayList();
        for (int i = 0; i < nrinstances; ++i) {
            int id = tree.getNode(i).getId();
            Node node = new Node(id);
            this.nodes.add(node);
            if (tree.getRootId() != id) continue;
            this.root = node;
        }
        for (Edge edge : edges) {
            Node parent = this.getNode(edge.getSource());
            Node ch = this.getNode(edge.getTarget());
            ch.parent = parent;
            ch.dist = edge.getWeight();
            parent.children.add(ch);
        }
    }

    protected boolean init(SimpleTreeModel tree) {
        if (tree.getSelectedConnectivity() == null) {
            return false;
        }
        ArrayList<Edge> edges = tree.getSelectedConnectivity().getEdges();
        ArrayList<AbstractInstance> instances = tree.getInstances();
        if (instances != null) {
            this.nodes = new ArrayList();
            for (AbstractInstance instance : instances) {
                int id = instance.getId();
                Node node = new Node(id);
                this.nodes.add(node);
                if (tree.getRoot() != id) continue;
                this.root = node;
            }
            if (tree.getRoot() == -1) {
                this.root = this.nodes.get(instances.size() - 1);
            }
            for (Edge edge : edges) {
                Node parent = this.getNode(edge.getSource());
                Node ch = this.getNode(edge.getTarget());
                ch.parent = parent;
                ch.dist = edge.getWeight();
                parent.children.add(ch);
            }
        } else {
            return false;
        }
        return true;
    }

    protected void postorderTraversal(Node v) {
        if (v.children.isEmpty()) {
            v.l = 1.0f;
        } else {
            v.l = 0.0f;
            for (Node w : v.children) {
                this.postorderTraversal(w);
                v.l += w.l;
            }
        }
    }

    private void preorderTraversal(Node v) {
        if (v != this.root) {
            Node u = v.parent;
            v.x = u.x + v.dist * (float)Math.cos(v.t + v.w / 2.0f);
            v.y = u.y + v.dist * (float)Math.sin(v.t + v.w / 2.0f);
        }
        float n = v.t;
        for (Node w : v.children) {
            w.w = w.l / this.root.l * ((float)Math.PI * 2);
            w.t = n;
            n += w.w;
            this.preorderTraversal(w);
        }
    }

    protected Node getNode(int id) {
        for (Node node : this.nodes) {
            if (node.id != id) continue;
            return node;
        }
        return null;
    }

    public class Node {
        public int id;
        public float x;
        public float y;
        public float w;
        public float t;
        public float l;
        public Node parent;
        public float dist;
        public ArrayList<Node> children = new ArrayList();
        public int clusterSize = 0;

        public Node(int id) {
            this.id = id;
        }
    }
}

