/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.reader.BinaryMatrixReader;
import simpletree.matrix.sparse.SparseMatrix;

public class MatrixFactory {
    public static AbstractMatrix getInstance(Class type) throws IOException {
        AbstractMatrix matrix = null;
        try {
            matrix = (AbstractMatrix)type.newInstance();
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MatrixFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MatrixFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return matrix;
    }

    public static AbstractMatrix getInstance(String filename) throws IOException {
        AbstractMatrix matrix = null;
        if (filename.toLowerCase().endsWith("data") || filename.toLowerCase().endsWith("prj") || filename.toLowerCase().endsWith("2d") || filename.toLowerCase().endsWith("nd")) {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            char[] header = in.readLine().trim().toCharArray();
            if (header.length != 2 && header.length != 3) {
                throw new IOException("Wrong format of header information.");
            }
            in.close();
            if (header[0] == 'D') {
                matrix = new DenseMatrix();
            } else if (header[0] == 'S') {
                matrix = new SparseMatrix();
            } else {
                throw new IOException("Unknow file format!");
            }
            ((AbstractMatrix)matrix).load(filename);
            Logger.getLogger(MatrixFactory.class.getName()).log(Level.INFO, "#Processing the points file: {0}", filename);
        } else if (filename.toLowerCase().endsWith("bin")) {
            BinaryMatrixReader bmr = new BinaryMatrixReader();
            matrix = bmr.read(filename);
        }
        return matrix;
    }
}

