/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.reader.MatrixReaderComp;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Points.Util", name="Points Intersection", description="It returns a matrix with the intersection between matrix A and B. Only the attributes of matrix A will be considered.")
public class IntersectionComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient AbstractMatrix matrixA;
    private transient AbstractMatrix matrixB;
    private transient AbstractMatrix intersecMatrix;

    public void execute() throws IOException {
        if (this.matrixA != null && this.matrixB != null) {
            this.intersecMatrix = new DenseMatrix();
            ArrayList<String> attrs = new ArrayList<String>();
            attrs.addAll(this.matrixA.getAttributes());
            this.intersecMatrix.setAttributes(attrs);
            ArrayList<Integer> matrixAIds = this.matrixA.getIds();
            ArrayList<Integer> matrixBIds = this.matrixB.getIds();
            for (int i = 0; i < this.matrixA.getRowCount(); ++i) {
                Integer id = matrixAIds.get(i);
                if (!matrixBIds.contains(id)) continue;
                this.intersecMatrix.addRow(this.matrixA.getRow(i), this.matrixA.getLabel(i));
            }
        } else {
            throw new IOException("Matrix A and B should be provided.");
        }
    }

    public void input(@Param(name="matrix A") AbstractMatrix matrix, @Param(name="matrix B") AbstractMatrix samplematrix) {
        this.matrixA = matrix;
        this.matrixB = samplematrix;
    }

    public AbstractMatrix output() {
        return this.intersecMatrix;
    }

    public void reset() {
        this.matrixA = null;
        this.matrixB = null;
        this.intersecMatrix = null;
    }

    public AbstractParametersView getParametersEditor() {
        return null;
    }

    public static void main(String[] args) {
        try {
            String filename = "C:\\Users\\DaniloEler\\Documents\\Fibras\\brain1_scan1_fiber_track_mni.data";
            MatrixReaderComp reader = new MatrixReaderComp();
            reader.setFilename(filename);
            reader.execute();
            filename = "C:\\Users\\DaniloEler\\Documents\\Fibras\\brain1_scan1_fiber_track_mni_class.data";
            MatrixReaderComp readerSample = new MatrixReaderComp();
            readerSample.setFilename(filename);
            readerSample.execute();
            IntersectionComp intersection = new IntersectionComp();
            intersection.input(reader.output(), readerSample.output());
            intersection.execute();
            System.out.println("# of matrix A           : " + reader.output().getRowCount());
            System.out.println("# of matrix B           : " + readerSample.output().getRowCount());
            System.out.println("# of intersection matrix: " + intersection.output().getRowCount());
            System.out.println("# of attributs          : " + intersection.output().getAttributes().size());
            System.out.println("# of labels             : " + intersection.output().getLabels().size());
        }
        catch (IOException ex) {
            Logger.getLogger(IntersectionComp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

