/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.util;

import java.io.IOException;
import java.util.Arrays;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;

public class MatrixMap {
    private final int[] ids;
    private final int[] rowIndices;

    public MatrixMap(AbstractMatrix matrix) {
        this.ids = new int[matrix.getRowCount()];
        this.rowIndices = new int[matrix.getRowCount()];
        this.buildAndSort(matrix);
    }

    private void buildAndSort(AbstractMatrix matrix) {
        int i;
        Object[] elementArray = new MapElement[matrix.getRowCount()];
        for (i = 0; i < matrix.getRowCount(); ++i) {
            elementArray[i] = new MapElement(matrix.getRow(i).getId(), i);
        }
        Arrays.sort(elementArray);
        for (i = 0; i < elementArray.length; ++i) {
            this.ids[i] = ((MapElement)elementArray[i]).id;
            this.rowIndices[i] = ((MapElement)elementArray[i]).rowIndex;
        }
    }

    public int getRowIndex(int id) {
        int idIndex = Arrays.binarySearch(this.ids, id);
        if (idIndex > 0) {
            return this.rowIndices[idIndex];
        }
        return -1;
    }

    public static void main(String[] args) throws IOException {
        long initTime = System.currentTimeMillis();
        AbstractMatrix matrix = MatrixFactory.getInstance("D:\\kdd900k_sampled.data");
        MatrixMap matrixMap = new MatrixMap(matrix);
        long endTime = System.currentTimeMillis();
        System.out.println("This process took: " + (float)(endTime - initTime) / 1000.0f + "s");
        initTime = System.currentTimeMillis();
        int elementIndex = matrixMap.getRowIndex(-2018936047);
        endTime = System.currentTimeMillis();
        System.out.println("This process took: " + (float)(endTime - initTime) / 1000.0f + "s");
    }

    private class MapElement
    implements Comparable {
        private int id;
        private int rowIndex;

        public MapElement(int id, int index) {
            this.id = id;
            this.rowIndex = index;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            if (this.getId() > ((MapElement)o).getId()) {
                return 1;
            }
            return -1;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }
    }
}

