/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import simpletree.model.AbstractInstance;
import simpletree.model.Edge;
import simpletree.model.GraphInstance;
import simpletree.model.GraphModel;

public class Connectivity
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String name;
    private ArrayList<Edge> edges;
    private boolean showweight;

    public Connectivity(String name, ArrayList<Edge> edges) {
        this.name = name;
        this.edges = this.compress(edges);
        this.showweight = false;
    }

    public void draw(GraphModel model, BufferedImage image, boolean highquality) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        ArrayList<AbstractInstance> instances = model.getInstances();
        int size = this.edges.size();
        for (int i = 0; i < size; ++i) {
            GraphInstance source = (GraphInstance)instances.get(this.edges.get(i).getSource());
            GraphInstance target = (GraphInstance)instances.get(this.edges.get(i).getTarget());
            if (!source.isValid() && !target.isValid()) {
                g2.setColor(Color.BLACK);
            } else {
                float alpha = model.getAlpha();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                g2.setColor(new Color((source.getColor().getRed() + target.getColor().getRed()) / 2, (source.getColor().getGreen() + target.getColor().getGreen()) / 2, (source.getColor().getBlue() + target.getColor().getBlue()) / 2));
            }
            g2.setStroke(new BasicStroke(1.3f));
            g2.drawLine((int)source.getX(), (int)source.getY(), (int)target.getX(), (int)target.getY());
            g2.setStroke(new BasicStroke(1.0f));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            if (!this.showweight) continue;
            String label = Float.toString(this.edges.get(i).getWeight());
            float x = 5.0f + Math.abs(source.getX() - target.getX()) / 2.0f + Math.min(source.getX(), target.getX());
            float y = Math.abs(source.getY() - target.getY()) / 2.0f + Math.min(source.getY(), target.getY());
            FontMetrics metrics = g2.getFontMetrics(g2.getFont());
            int width = metrics.stringWidth(label);
            int height = metrics.getAscent();
            g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
            g2.setPaint(Color.WHITE);
            g2.fill(new Rectangle((int)x - 2, (int)y - height, width + 4, height + 4));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setColor(Color.BLACK);
            g2.drawRect((int)x - 2, (int)y - height, width + 4, height + 4);
            g2.drawString(label, x, y);
        }
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }

    public String getName() {
        return this.name;
    }

    private ArrayList<Edge> compress(ArrayList<Edge> edges) {
        if (edges.size() > 0) {
            Collections.sort(edges);
            ArrayList<Edge> edges_aux = edges;
            edges = new ArrayList();
            int n = 0;
            edges.add(edges_aux.get(0));
            for (int i = 1; i < edges_aux.size(); ++i) {
                if (edges_aux.get(n).equals(edges_aux.get(i))) continue;
                edges.add(edges_aux.get(i));
                n = i;
            }
        }
        return edges;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Connectivity) {
            return this.name.equals(((Connectivity)obj).name);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3 + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.name;
    }

    public boolean isShowWeight() {
        return this.showweight;
    }

    public void setShowWeight(boolean showweight) {
        this.showweight = showweight;
    }
}

