/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.Color;
import java.io.Serializable;

public class Edge
implements Comparable,
Serializable {
    public static final float NO_SIZE = -1.0f;
    private static final long serialVersionUID = 1L;
    private float weight = -1.0f;
    private Color color = Color.WHITE;
    private int source;
    private int target;

    public Edge(int source, int target, float weight) {
        this(source, target);
        this.weight = weight;
    }

    public Edge(int source, int target) {
        this.source = source;
        this.target = target;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getSource() {
        return this.source;
    }

    public int getTarget() {
        return this.target;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Edge) {
            Edge e = (Edge)obj;
            return this.source == e.source && this.target == e.target || this.source == e.target && this.target == e.source;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3 + 5 * this.source;
        return hash += 7 * this.target;
    }

    public int compareTo(Object o) {
        long source_aux = 0L;
        long target_aux = 0L;
        if (this.source < this.target) {
            source_aux = this.source;
            target_aux = this.target;
        } else {
            source_aux = this.target;
            target_aux = this.source;
        }
        long sourceComp = 0L;
        long targetComp = 0L;
        if (((Edge)o).source < ((Edge)o).target) {
            sourceComp = ((Edge)o).source;
            targetComp = ((Edge)o).target;
        } else {
            sourceComp = ((Edge)o).target;
            targetComp = ((Edge)o).source;
        }
        if (source_aux - sourceComp < 0L) {
            return -1;
        }
        if (source_aux - sourceComp > 0L) {
            return 1;
        }
        if (target_aux - targetComp < 0L) {
            return -1;
        }
        if (target_aux - targetComp > 0L) {
            return 1;
        }
        return 0;
    }

    public float getWeight() {
        return this.weight;
    }

    public String toString() {
        return "(" + this.source + "," + this.target + ")";
    }
}

