/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import simpletree.forcelayout.ForceData;
import simpletree.model.GraphModel;
import simpletree.model.ProjectionInstance;

public class GraphInstance
extends ProjectionInstance {
    public ForceData fdata;
    private float sizefactor = 0.0f;
    private boolean drawAsCircles = true;
    private boolean valid = true;

    public GraphInstance(int id, float x, float y) {
        super(id, x, y);
    }

    public GraphInstance(int id) {
        this(id, 0.0f, 0.0f);
    }

    @Override
    public void draw(BufferedImage image, boolean highquality) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        GraphModel gmodel = (GraphModel)this.model;
        if (this.drawAsCircles) {
            int inssize;
            if (this.selected) {
                inssize = gmodel.getInstanceSize();
                g2.setStroke(new BasicStroke(4.0f));
                inssize = (int)((double)inssize * 1.5);
                g2.setColor(this.color);
                g2.fillOval((int)this.x - inssize, (int)this.y - inssize, inssize * 2, inssize * 2);
                g2.setColor(Color.DARK_GRAY);
                g2.drawOval((int)this.x - inssize, (int)this.y - inssize, inssize * 2, inssize * 2);
                g2.setStroke(new BasicStroke(1.0f));
            } else {
                inssize = gmodel.getInstanceSize();
                g2.setComposite(AlphaComposite.getInstance(3, gmodel.getAlpha()));
                g2.setColor(this.color);
                g2.fillOval((int)this.x - inssize, (int)this.y - inssize, inssize * 2, inssize * 2);
                g2.setColor(Color.BLACK);
                g2.drawOval((int)this.x - inssize, (int)this.y - inssize, inssize * 2, inssize * 2);
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        } else if (this.selected) {
            int rgbcolor = this.color.getRGB();
            image.setRGB((int)this.x - 1, (int)this.y - 1, rgbcolor);
            image.setRGB((int)this.x, (int)this.y - 1, rgbcolor);
            image.setRGB((int)this.x + 1, (int)this.y - 1, rgbcolor);
            image.setRGB((int)this.x - 1, (int)this.y, rgbcolor);
            image.setRGB((int)this.x, (int)this.y, rgbcolor);
            image.setRGB((int)this.x + 1, (int)this.y, rgbcolor);
            image.setRGB((int)this.x - 1, (int)this.y + 1, rgbcolor);
            image.setRGB((int)this.x, (int)this.y + 1, rgbcolor);
            image.setRGB((int)this.x + 1, (int)this.y + 1, rgbcolor);
            g2.setColor(Color.GRAY);
            g2.drawRect((int)this.x - 2, (int)this.y - 2, 4, 4);
        } else {
            int rgb = this.color.getRGB();
            float alpha = ((GraphModel)this.model).getAlpha();
            this.simulateAlpha(image, alpha, (int)this.x - 1, (int)this.y - 1, rgb);
            this.simulateAlpha(image, alpha, (int)this.x, (int)this.y - 1, rgb);
            this.simulateAlpha(image, alpha, (int)this.x + 1, (int)this.y - 1, rgb);
            this.simulateAlpha(image, alpha, (int)this.x - 1, (int)this.y, rgb);
            this.simulateAlpha(image, alpha, (int)this.x, (int)this.y, rgb);
            this.simulateAlpha(image, alpha, (int)this.x + 1, (int)this.y, rgb);
            this.simulateAlpha(image, alpha, (int)this.x - 1, (int)this.y + 1, rgb);
            this.simulateAlpha(image, alpha, (int)this.x, (int)this.y + 1, rgb);
            this.simulateAlpha(image, alpha, (int)this.x + 1, (int)this.y + 1, rgb);
        }
        if (this.showlabel) {
            FontMetrics metrics = g2.getFontMetrics(g2.getFont());
            int width = metrics.stringWidth(this.toString().trim());
            int height = metrics.getAscent();
            g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
            g2.setPaint(Color.WHITE);
            g2.fillRect((int)this.x + 3, (int)this.y - 1 - height, width + 4, height + 4);
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setColor(Color.DARK_GRAY);
            g2.drawRect((int)this.x + 3, (int)this.y - 1 - height, width + 4, height + 4);
            g2.drawString(this.toString().trim(), (int)this.x + 3, (int)this.y);
        }
    }

    @Override
    public boolean isInside(int x, int y) {
        return Math.sqrt(Math.pow((float)x - this.x, 2.0) + Math.pow((float)y - this.y, 2.0)) <= (double)this.getSize();
    }

    public float getSizeFactor() {
        return this.sizefactor;
    }

    public void setSizeFactor(float sizefactor) {
        if (this.model == null) {
            throw new NullPointerException("This instance should be added to a model before using this method!");
        }
        this.sizefactor = sizefactor;
        this.model.setChanged();
    }

    public int getSize() {
        if (this.model == null) {
            throw new NullPointerException("This instance should be added to a model before using this method!");
        }
        int inssize = ((GraphModel)this.model).getInstanceSize();
        return (int)((float)inssize + this.sizefactor * (float)inssize);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

