/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import simpletree.model.Connectivity;
import simpletree.model.GraphInstance;
import simpletree.model.ProjectionModel;

public class GraphModel
extends ProjectionModel {
    private int instancesize = 4;
    protected Connectivity selsconn = null;
    protected ArrayList<Connectivity> connectivities = new ArrayList();

    @Override
    public void draw(BufferedImage image, boolean highquality) {
        if (image != null) {
            if (this.selsconn != null) {
                this.selsconn.draw(this, image, highquality);
            }
            super.draw(image, highquality);
        }
    }

    public Connectivity getSelectedConnectivity() {
        return this.selsconn;
    }

    public void setSelectedConnectivity(Connectivity conn) {
        if (this.connectivities.contains(conn)) {
            this.selsconn = conn;
        } else {
            this.selscalar = null;
        }
        this.setChanged();
    }

    public ArrayList<Connectivity> getConnectivities() {
        return this.connectivities;
    }

    public Connectivity getConnectivityByName(String name) {
        for (Connectivity c : this.connectivities) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public void addConnectivity(Connectivity connectivity) {
        this.removeConnectivity(connectivity);
        this.connectivities.add(connectivity);
    }

    public void removeConnectivity(Connectivity connectivity) {
        this.connectivities.remove(connectivity);
    }

    public int getInstanceSize() {
        return this.instancesize;
    }

    public void setInstanceSize(int instancesize) {
        this.instancesize = instancesize;
        this.setChanged();
    }

    public void perturb() {
        Random rand = new Random(7L);
        float maxx = Float.NEGATIVE_INFINITY;
        float minx = Float.POSITIVE_INFINITY;
        float maxy = Float.NEGATIVE_INFINITY;
        float miny = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.instances.size(); ++i) {
            GraphInstance pi = (GraphInstance)this.instances.get(i);
            if (maxx < pi.getX()) {
                maxx = pi.getX();
            }
            if (minx > pi.getX()) {
                minx = pi.getX();
            }
            if (maxy < pi.getY()) {
                maxy = pi.getY();
            }
            if (!(miny > pi.getY())) continue;
            miny = pi.getY();
        }
        float diffx = (maxx - minx) / 1000.0f;
        float diffy = (maxy - miny) / 1000.0f;
        for (int i = 0; i < this.instances.size(); ++i) {
            GraphInstance pi = (GraphInstance)this.instances.get(i);
            pi.setX(pi.getX() + diffx * rand.nextFloat());
            pi.setY(pi.getY() + diffy * rand.nextFloat());
        }
    }

    public void createConnectivities() {
    }
}

