/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import simpletree.basics.color.ColorScaleFactory;
import simpletree.basics.color.ColorTable;
import simpletree.model.AbstractModel;
import simpletree.model.ProjectionInstance;
import simpletree.model.Scalar;

public class ProjectionModel
extends AbstractModel {
    protected ArrayList<Scalar> scalars = new ArrayList();
    protected float alpha = 1.0f;
    protected ColorTable colortable = new ColorTable();
    protected Scalar selscalar = null;

    public void draw(BufferedImage image, boolean highquality) {
        if (image != null) {
            ProjectionInstance pi;
            int i;
            for (i = 0; i < this.instances.size(); ++i) {
                pi = (ProjectionInstance)this.instances.get(i);
                if (pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
            for (i = 0; i < this.instances.size(); ++i) {
                pi = (ProjectionInstance)this.instances.get(i);
                if (!pi.isSelected()) continue;
                pi.draw(image, highquality);
            }
        }
    }

    public ProjectionInstance getInstanceByPosition(Point point) {
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (!pi.isInside(point.x, point.y)) continue;
            return pi;
        }
        return null;
    }

    public ArrayList<ProjectionInstance> getInstancesByPosition(Rectangle rect) {
        ArrayList<ProjectionInstance> selected = new ArrayList<ProjectionInstance>();
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (!pi.isInside(rect)) continue;
            selected.add(pi);
        }
        return selected;
    }

    public ArrayList<ProjectionInstance> getInstancesByPosition(Polygon polygon) {
        ArrayList<ProjectionInstance> selected = new ArrayList<ProjectionInstance>();
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (!polygon.contains(pi.getX(), pi.getY())) continue;
            selected.add(pi);
        }
        return selected;
    }

    public void fitToSize(Dimension size) {
        float maxx = Float.NEGATIVE_INFINITY;
        float minx = Float.POSITIVE_INFINITY;
        float maxy = Float.NEGATIVE_INFINITY;
        float miny = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (maxx < pi.getX()) {
                maxx = pi.getX();
            }
            if (minx > pi.getX()) {
                minx = pi.getX();
            }
            if (maxy < pi.getY()) {
                maxy = pi.getY();
            }
            if (!(miny > pi.getY())) continue;
            miny = pi.getY();
        }
        float begin = 50.0f;
        float endy = 0.0f;
        float endx = 0.0f;
        if (maxy > maxx) {
            endy = (float)Math.min(size.width, size.height) - begin;
            endx = maxy != miny ? (maxx - minx) * endy / (maxy - miny) : (maxx - minx) * endy;
        } else {
            endx = (float)Math.min(size.width, size.height) - begin;
            endy = maxx != minx ? (maxy - miny) * endx / (maxx - minx) : (maxy - miny) * endx;
        }
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (maxx != minx) {
                pi.setX((pi.getX() - minx) / (maxx - minx) * (endx - begin) + begin);
            } else {
                pi.setX(begin);
            }
            if (maxy != miny) {
                pi.setY((pi.getY() - miny) / (maxy - miny) * (endy - begin) + begin);
                continue;
            }
            pi.setY(begin);
        }
        this.setChanged();
    }

    public Dimension getSize() {
        if (this.instances.size() > 0) {
            float maxx = Float.MIN_VALUE;
            float maxy = Float.MIN_VALUE;
            for (int i = 0; i < this.instances.size(); ++i) {
                ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
                if (maxx < pi.getX()) {
                    maxx = pi.getX();
                }
                if (!(maxy < pi.getY())) continue;
                maxy = pi.getY();
            }
            int w = (int)maxx + 30;
            int h = (int)maxy + 30;
            return new Dimension(w, h);
        }
        return new Dimension(0, 0);
    }

    public Rectangle getBoundingBox() {
        if (this.instances.size() > 0) {
            float maxx = Float.MIN_VALUE;
            float maxy = Float.MIN_VALUE;
            float minx = Float.MAX_VALUE;
            float miny = Float.MAX_VALUE;
            for (int i = 0; i < this.instances.size(); ++i) {
                ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
                if (maxx < pi.getX()) {
                    maxx = pi.getX();
                }
                if (maxy < pi.getY()) {
                    maxy = pi.getY();
                }
                minx = Math.min(minx, pi.x);
                miny = Math.min(miny, pi.y);
            }
            return new Rectangle((int)minx, (int)miny, (int)(maxx - minx), (int)(maxy - miny));
        }
        return null;
    }

    public Scalar addScalar(String name) {
        Scalar scalar = new Scalar(name);
        if (!this.scalars.contains(scalar)) {
            this.scalars.add(scalar);
            return scalar;
        }
        return this.scalars.get(this.scalars.indexOf(scalar));
    }

    public ArrayList<Scalar> getScalars() {
        return this.scalars;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        this.setChanged();
    }

    public void changeColorScaleType(ColorScaleFactory.ColorScaleType scaletype) {
        this.colortable.setColorScaleType(scaletype);
        this.setSelectedScalar(this.selscalar);
        this.setChanged();
    }

    public ColorTable getColorTable() {
        return this.colortable;
    }

    public Scalar getSelectedScalar() {
        return this.selscalar;
    }

    public void setSelectedScalar(Scalar scalar) {
        if (this.scalars.contains(scalar)) {
            this.selscalar = scalar;
            for (int i = 0; i < this.instances.size(); ++i) {
                ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
                if (scalar.getMin() >= 0.0f && scalar.getMax() <= 1.0f) {
                    pi.setColor(this.colortable.getColor(pi.getScalarValue(scalar)));
                    continue;
                }
                pi.setColor(this.colortable.getColor(pi.getNormalizedScalarValue(scalar)));
            }
        } else {
            this.selscalar = null;
            for (int i = 0; i < this.instances.size(); ++i) {
                ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
                pi.setColor(Color.BLACK);
            }
        }
        this.setChanged();
    }

    public void zoom(float rate) {
        float maxX = Float.NEGATIVE_INFINITY;
        float minX = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (maxX < pi.getX()) {
                maxX = pi.getX();
            }
            if (minX > pi.getX()) {
                minX = pi.getX();
            }
            if (maxY < pi.getY()) {
                maxY = pi.getY();
            }
            if (!(minY > pi.getY())) continue;
            minY = pi.getY();
        }
        float endX = maxX * rate;
        float endY = maxY * rate;
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (maxX != minX) {
                pi.setX((pi.getX() - minX) / (maxX - minX) * (endX - minX) + minX);
            } else {
                pi.setX(minX);
            }
            if (maxY != minY) {
                pi.setY((pi.getY() - minY) / (maxY - minY) * (endY - minY) + minY);
                continue;
            }
            pi.setY(minY);
        }
        this.setChanged();
    }

    public void normalizeVertex(float begin, float end) {
        float maxX = Float.NEGATIVE_INFINITY;
        float minX = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (maxX < pi.getX()) {
                maxX = pi.getX();
            }
            if (minX > pi.getX()) {
                minX = pi.getX();
            }
            if (maxY < pi.getY()) {
                maxY = pi.getY();
            }
            if (!(minY > pi.getY())) continue;
            minY = pi.getY();
        }
        float endX = (maxX - minX) * end;
        if (maxY != minY) {
            endX = (maxX - minX) * end / (maxY - minY);
        }
        for (int i = 0; i < this.instances.size(); ++i) {
            ProjectionInstance pi = (ProjectionInstance)this.instances.get(i);
            if (maxX != minX) {
                pi.setX((pi.getX() - minX) / (maxX - minX) * (endX - begin) + begin);
            } else {
                pi.setX(begin);
            }
            if (maxY != minY) {
                pi.setY((pi.getY() - minY) / (maxY - minY) * (end - begin) + begin);
                continue;
            }
            pi.setY(begin);
        }
    }
}

