/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.io.IOException;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.model.ProjectionInstance;
import simpletree.model.ProjectionModel;
import simpletree.model.Scalar;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Basics", name="Projection Model", description="Create a projection model to be visualized.")
public class ProjectionModelComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient ProjectionModel model;
    private transient AbstractMatrix projection;

    public void execute() throws IOException {
        if (this.projection != null) {
            this.model = new ProjectionModel();
            Scalar cdata = this.model.addScalar("cdata");
            Scalar dots = this.model.addScalar("...");
            Scalar dColor = this.model.addScalar("dynamic color");
            int nrows = this.projection.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                AbstractVector row = this.projection.getRow(i);
                ProjectionInstance pi = new ProjectionInstance(row.getId(), row.getValue(0), row.getValue(1));
                this.model.addInstance(pi);
                pi.setScalarValue(cdata, row.getKlass());
                pi.setScalarValue(dots, 0.0f);
                pi.setScalarValue(dColor, 0.0f);
            }
        } else {
            throw new IOException("A 2D projection should be provided.");
        }
    }

    public void input(@Param(name="2D projection") AbstractMatrix projection) {
        this.projection = projection;
    }

    public ProjectionModel output() {
        return this.model;
    }

    public AbstractParametersView getParametersEditor() {
        return null;
    }

    public void reset() {
        this.projection = null;
        this.model = null;
    }
}

