/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import simpletree.model.AbstractInstance;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;

public class SimpleTreeConnectivity
extends Connectivity {
    public SimpleTreeConnectivity(String name, ArrayList<Edge> edges) {
        super(name, edges);
    }

    public void draw(SimpleTreeModel model, Graphics2D g2, boolean highquality) {
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        ArrayList<AbstractInstance> selectedInstances = model.getSelectedInstances();
        for (Edge edge : this.getEdges()) {
            SimpleTreeInstance source = model.getInstanceById(edge.getSource());
            SimpleTreeInstance target = model.getInstanceById(edge.getTarget());
            if (source == null || target == null) continue;
            if (!source.isValid() && !target.isValid()) {
                g2.setColor(Color.BLACK);
            } else {
                float alpha = model.getAlpha();
                if (selectedInstances == null || selectedInstances.isEmpty()) {
                    alpha = 1.0f;
                }
                if (selectedInstances == null || selectedInstances.isEmpty() || model.isNoAlpha()) {
                    alpha = 1.0f;
                }
                for (AbstractInstance selectedInstance : selectedInstances) {
                    if (!source.equals(selectedInstance) && !target.equals(selectedInstance)) continue;
                    alpha = 1.0f;
                    break;
                }
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                g2.setColor(new Color((source.getColor().getRed() + target.getColor().getRed()) / 2, (source.getColor().getGreen() + target.getColor().getGreen()) / 2, (source.getColor().getBlue() + target.getColor().getBlue()) / 2));
            }
            g2.setStroke(new BasicStroke(1.3f));
            g2.drawLine((int)source.getX(), (int)source.getY(), (int)target.getX(), (int)target.getY());
            g2.setStroke(new BasicStroke(1.0f));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            if (!this.isShowWeight()) continue;
            this.drawWeight(g2, edge, model);
        }
    }

    public void draw(SimpleTreeModel model, BufferedImage image, boolean highquality) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        this.draw(model, g2, highquality);
    }

    public void draw(SimpleTreeModel model, BufferedImage image, boolean highquality, ArrayList<AbstractInstance> validInstances) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        ArrayList<AbstractInstance> instances = model.getInstances();
        ArrayList<Edge> edges = this.getEdges();
        int size = edges.size();
        ArrayList<AbstractInstance> selectedInstances = model.getSelectedInstances();
        for (int i = 0; i < size; ++i) {
            boolean validEdge;
            SimpleTreeInstance source = model.getInstanceById(edges.get(i).getSource());
            SimpleTreeInstance target = model.getInstanceById(edges.get(i).getTarget());
            boolean bl = validEdge = validInstances.contains(source) && validInstances.contains(target);
            if (source == null || target == null || !validEdge) continue;
            if (!source.isValid() && !target.isValid()) {
                g2.setColor(Color.BLACK);
            } else {
                float alpha = model.getAlpha();
                if (selectedInstances == null || selectedInstances.size() == 0) {
                    alpha = 1.0f;
                }
                if (selectedInstances == null || selectedInstances.size() == 0 || model.isNoAlpha()) {
                    alpha = 1.0f;
                }
                for (int j = 0; j < selectedInstances.size(); ++j) {
                    if (!source.equals(selectedInstances.get(j)) && !target.equals(selectedInstances.get(j))) continue;
                    alpha = 1.0f;
                    break;
                }
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                g2.setColor(new Color((source.getColor().getRed() + target.getColor().getRed()) / 2, (source.getColor().getGreen() + target.getColor().getGreen()) / 2, (source.getColor().getBlue() + target.getColor().getBlue()) / 2));
            }
            g2.setStroke(new BasicStroke(1.3f));
            g2.drawLine((int)source.getX(), (int)source.getY(), (int)target.getX(), (int)target.getY());
            g2.setStroke(new BasicStroke(1.0f));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            if (!this.isShowWeight()) continue;
            String label = Float.toString(edges.get(i).getWeight());
            float x = 5.0f + Math.abs(source.getX() - target.getX()) / 2.0f + Math.min(source.getX(), target.getX());
            float y = Math.abs(source.getY() - target.getY()) / 2.0f + Math.min(source.getY(), target.getY());
            FontMetrics metrics = g2.getFontMetrics(g2.getFont());
            int width = metrics.stringWidth(label);
            int height = metrics.getAscent();
            g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
            g2.setPaint(Color.WHITE);
            g2.fill(new Rectangle((int)x - 2, (int)y - height, width + 4, height + 4));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setColor(Color.BLACK);
            g2.drawRect((int)x - 2, (int)y - height, width + 4, height + 4);
            g2.drawString(label, x, y);
        }
    }

    public void drawWeight(Graphics2D g2, Edge edge, SimpleTreeModel model) {
        SimpleTreeInstance source = model.getInstanceById(edge.getSource());
        SimpleTreeInstance target = model.getInstanceById(edge.getTarget());
        String label = Float.toString(edge.getWeight());
        float x = 5.0f + Math.abs(source.getX() - target.getX()) / 2.0f + Math.min(source.getX(), target.getX());
        float y = Math.abs(source.getY() - target.getY()) / 2.0f + Math.min(source.getY(), target.getY());
        FontMetrics metrics = g2.getFontMetrics(g2.getFont());
        int width = metrics.stringWidth(label);
        int height = metrics.getAscent();
        g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
        g2.setPaint(Color.WHITE);
        g2.fill(new Rectangle((int)x - 2, (int)y - height, width + 4, height + 4));
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setColor(Color.BLACK);
        g2.drawRect((int)x - 2, (int)y - height, width + 4, height + 4);
        g2.drawString(label, x, y);
    }
}

