/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.io.IOException;
import simpletree.model.ProjectionModel;
import simpletree.model.XMLModelWriter;
import simpletree.model.XMLModelWriterParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Output", name="Projection Model  XML writer", description="Write a projection model to a XML file.")
public class XMLModelWriterComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private transient XMLModelWriterParamView paramview;
    private transient ProjectionModel model;

    public void execute() throws IOException {
        if (this.filename.trim().length() > 0) {
            if (this.model == null) {
                throw new IOException("A projection model must be provided to write.");
            }
        } else {
            throw new IOException("A projection model file name must be provided to write.");
        }
        XMLModelWriter xmw = new XMLModelWriter();
        xmw.write(this.model, this.filename);
    }

    public void input(@Param(name="model") ProjectionModel model) {
        this.model = model;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new XMLModelWriterParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

