/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.bin;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.model.AbstractInstance;
import simpletree.model.Connectivity;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;

public class BINSimpleTreeModelReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTreeModel read(String filename) throws IOException {
        FileInputStream fis = null;
        SimpleTreeModel modelRet = null;
        try {
            int numInstances;
            fis = new FileInputStream(filename);
            ObjectInputStream ois = new ObjectInputStream(fis);
            modelRet = new SimpleTreeModel();
            int root = (Integer)ois.readObject();
            modelRet.setRoot(root);
            String type = (String)ois.readObject();
            modelRet.setType(type);
            int imagesSize = (Integer)ois.readObject();
            modelRet.setImagesSize(imagesSize);
            float alpha = ((Float)ois.readObject()).floatValue();
            modelRet.setAlpha(alpha);
            ArrayList connectivities = (ArrayList)ois.readObject();
            modelRet.setConnectivities(connectivities);
            int selsconn = (Integer)ois.readObject();
            if (selsconn != -1) {
                modelRet.setSelectedConnectivity((Connectivity)connectivities.get(selsconn));
            }
            int instanceSize = (Integer)ois.readObject();
            modelRet.setInstanceSize(instanceSize);
            int numScalars = (Integer)ois.readObject();
            if (numScalars != 0) {
                ArrayList<Scalar> scalars = new ArrayList<Scalar>();
                for (int i = 0; i < numScalars; ++i) {
                    String scalarInfo = (String)ois.readObject();
                    String[] values = scalarInfo.split("#");
                    if (values.length != 3) continue;
                    Scalar sc = new Scalar(values[0]);
                    sc.setMin(Float.parseFloat(values[1]));
                    sc.setMax(Float.parseFloat(values[2]));
                    scalars.add(sc);
                }
                modelRet.setScalars(scalars);
                int selScalarInfo = (Integer)ois.readObject();
                if (selScalarInfo != -1) {
                    Scalar selscalar = scalars.get(selScalarInfo);
                    modelRet.setSelectedScalar(selscalar);
                }
            }
            if ((numInstances = ((Integer)ois.readObject()).intValue()) != 0) {
                ArrayList<AbstractInstance> instances = new ArrayList<AbstractInstance>();
                for (int i = 0; i < numInstances; ++i) {
                    int j;
                    int parent = (Integer)ois.readObject();
                    Integer[] children = (Integer[])ois.readObject();
                    boolean valid = (Boolean)ois.readObject();
                    float x = ((Float)ois.readObject()).floatValue();
                    float y = ((Float)ois.readObject()).floatValue();
                    Color color = (Color)ois.readObject();
                    int id = (Integer)ois.readObject();
                    SimpleTreeInstance sti = new SimpleTreeInstance(modelRet, id, x, y, valid);
                    sti.setColor(color);
                    sti.setParent(parent);
                    for (j = 0; j < children.length; ++j) {
                        sti.setChildrenId(j, children[j]);
                    }
                    if (numScalars != 0) {
                        for (j = 0; j < numScalars; ++j) {
                            float v = ((Float)ois.readObject()).floatValue();
                            sti.setScalarValue(modelRet.getScalars().get(j), v);
                        }
                    }
                    instances.add(sti);
                }
                modelRet.setInstances(instances);
            }
            SimpleTreeModel simpleTreeModel = modelRet;
            return simpleTreeModel;
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(BINSimpleTreeModelReader.class.getName()).log(Level.SEVERE, null, e);
            SimpleTreeModel simpleTreeModel = null;
            return simpleTreeModel;
        }
        catch (IOException e) {
            Logger.getLogger(BINSimpleTreeModelReader.class.getName()).log(Level.SEVERE, null, e);
            SimpleTreeModel simpleTreeModel = null;
            return simpleTreeModel;
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger(BINSimpleTreeModelReader.class.getName()).log(Level.SEVERE, null, e);
            SimpleTreeModel simpleTreeModel = null;
            return simpleTreeModel;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                Logger.getLogger(BINSimpleTreeModelReader.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }
}

