/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.bin;

import java.io.IOException;
import simpletree.model.SimpleTreeModel;
import simpletree.model.bin.BINSimpleTreeModelWriter;
import simpletree.model.bin.BINSimpleTreeModelWriterParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Output", name="Simple Tree Model Binary writer", description="Write a simple tree model to a BMODEL (Binary) file.")
public class BINSimpleTreeModelWriterComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private transient BINSimpleTreeModelWriterParamView paramview;
    private transient SimpleTreeModel model;

    public void execute() throws IOException {
        if (this.filename.trim().length() > 0) {
            if (this.model == null) {
                throw new IOException("A tree model must be provided to write.");
            }
        } else {
            throw new IOException("A tree model file name must be provided to write.");
        }
        BINSimpleTreeModelWriter xmw = new BINSimpleTreeModelWriter();
        xmw.write(this.model, this.filename);
    }

    public void input(@Param(name="model") SimpleTreeModel model) {
        this.model = model;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new BINSimpleTreeModelWriterParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

