/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.bin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import simpletree.model.bin.BINSimpleTreeModelWriterComp;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.BMODELFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class BINSimpleTreeModelWriterParamView
extends AbstractParametersView {
    private BINSimpleTreeModelWriterComp comp;
    private JButton matrixButton;
    private JLabel matrixLabel;
    private JTextField matrixTextField;

    public BINSimpleTreeModelWriterParamView(BINSimpleTreeModelWriterComp comp) {
        this.initComponents();
        this.comp = comp;
        this.reset();
    }

    private void initComponents() {
        this.matrixLabel = new JLabel();
        this.matrixTextField = new JTextField();
        this.matrixButton = new JButton();
        this.setBorder(BorderFactory.createTitledBorder("Binary Tree Model Writer"));
        this.setLayout(new GridBagLayout());
        this.matrixLabel.setText("File name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.matrixLabel, gridBagConstraints);
        this.matrixTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.matrixTextField, gridBagConstraints);
        this.matrixButton.setText("Search...");
        this.matrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BINSimpleTreeModelWriterParamView.this.matrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.matrixButton, gridBagConstraints);
    }

    private void matrixButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = SaveDialog.showSaveDialog(spm, new BMODELFilter(), (Component)((Object)this), "simpleTreeModel.bmodel");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                this.matrixTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(BINSimpleTreeModelWriterParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reset() {
        this.matrixTextField.setText(this.comp.getFilename());
    }

    public void finished() throws IOException {
        if (this.matrixTextField.getText().trim().length() <= 0) {
            throw new IOException("A matrix file name must be provided.");
        }
        this.comp.setFilename(this.matrixTextField.getText());
    }
}

