/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.newick;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import simpletree.model.newick.NewickTreeReaderComp;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.NEWICKFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class NewickTreeReaderParamView
extends AbstractParametersView {
    private NewickTreeReaderComp comp;
    private JLabel matrixLabel;
    private JCheckBox pnjCheckBox;
    private JButton treeButton;
    private JTextField treeTextField;

    public NewickTreeReaderParamView(NewickTreeReaderComp comp) {
        this.initComponents();
        this.comp = comp;
        this.reset();
    }

    private void initComponents() {
        this.matrixLabel = new JLabel();
        this.treeTextField = new JTextField();
        this.treeButton = new JButton();
        this.pnjCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Newick Tree Reader"));
        this.setLayout(new GridBagLayout());
        this.matrixLabel.setText("File name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.matrixLabel, gridBagConstraints);
        this.treeTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.treeTextField, gridBagConstraints);
        this.treeButton.setText("Search...");
        this.treeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewickTreeReaderParamView.this.treeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.treeButton, gridBagConstraints);
        this.pnjCheckBox.setText("Leaf Promotion");
        this.pnjCheckBox.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add(this.pnjCheckBox, gridBagConstraints);
    }

    private void treeButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, new NEWICKFilter(), (Component)((Object)this));
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.treeTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(NewickTreeReaderParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reset() {
        this.treeTextField.setText(this.comp.getFilename());
        this.pnjCheckBox.setSelected(this.comp.isPromotion());
    }

    public void finished() throws IOException {
        if (this.treeTextField.getText().trim().length() <= 0) {
            throw new IOException("A tree file name must be provided.");
        }
        this.comp.setFilename(this.treeTextField.getText());
        this.comp.setPromotion(this.pnjCheckBox.isSelected());
    }
}

