/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import simpletree.model.GraphInstance;
import simpletree.model.GraphModel;
import simpletree.model.Scalar;
import simpletree.util.Util;

public class XMLGraphModelReader
extends DefaultHandler {
    private GraphInstance tmpinstance;
    private GraphModel model;
    private static final String INSTANCE = "instance";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String X_COORDINATE = "x-coordinate";
    private static final String Y_COORDINATE = "y-coordinate";
    private static final String VALUE = "value";
    private static final String SCALAR = "scalar";

    public void read(GraphModel model, String filename) throws IOException {
        this.model = model;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            InputSource in = new InputSource(new InputStreamReader((InputStream)new FileInputStream(filename), "ISO-8859-1"));
            SAXParser sp = spf.newSAXParser();
            sp.parse(in, (DefaultHandler)this);
        }
        catch (SAXException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String value;
        super.startElement(uri, localName, qName, attributes);
        if (qName.equalsIgnoreCase(SCALAR)) {
            String name = attributes.getValue(NAME);
            String value2 = attributes.getValue(VALUE);
            if (name != null && value2 != null) {
                Scalar s = this.model.addScalar(name);
                this.tmpinstance.setScalarValue(s, Float.parseFloat(value2));
            }
        } else if (qName.equalsIgnoreCase(INSTANCE)) {
            String id = attributes.getValue(ID);
            this.tmpinstance = Util.isParsableToInt(id) ? new GraphInstance(Integer.parseInt(id)) : new GraphInstance(Util.convertToInt(id));
            this.model.addInstance(this.tmpinstance);
        } else if (qName.equalsIgnoreCase(X_COORDINATE)) {
            String value3 = attributes.getValue(VALUE);
            if (value3 != null) {
                this.tmpinstance.setX(Float.parseFloat(value3));
            }
        } else if (qName.equalsIgnoreCase(Y_COORDINATE) && (value = attributes.getValue(VALUE)) != null) {
            this.tmpinstance.setY(Float.parseFloat(value));
        }
    }
}

