/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeConnectivity;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.xml.XMLGraphModelReader;
import simpletree.util.Util;

public class XMLSimpleTreeModelReader
extends XMLGraphModelReader {
    private Connectivity con;
    ArrayList<Edge> edges;
    private SimpleTreeInstance tmpinstance;
    private SimpleTreeModel model;
    private String selconnValue;
    private static final String EDGE = "edge";
    private static final String SELCONN = "selconn";
    private static final String ROOT = "root";
    private static final String TYPE = "type";
    private static final String NOALPHA = "noalpha";
    private static final String ALPHA = "alpha";
    private static final String EDGES = "edges";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String LENGTH = "length";
    private static final String VALID = "valid";
    private static final String INSTANCE = "instance";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String X_COORDINATE = "x-coordinate";
    private static final String Y_COORDINATE = "y-coordinate";
    private static final String VALUE = "value";
    private static final String SCALAR = "scalar";

    public void read(SimpleTreeModel model, String filename) throws IOException {
        this.model = model;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            InputSource in = new InputSource(new InputStreamReader((InputStream)new FileInputStream(filename), "ISO-8859-1"));
            SAXParser sp = spf.newSAXParser();
            sp.parse(in, (DefaultHandler)this);
        }
        catch (SAXException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase(SCALAR)) {
            String name = attributes.getValue(NAME);
            String value = attributes.getValue(VALUE);
            if (name != null && value != null) {
                Scalar s = this.model.addScalar(name);
                this.tmpinstance.setScalarValue(s, Float.parseFloat(value));
            }
        } else if (qName.equalsIgnoreCase(INSTANCE)) {
            String id = attributes.getValue(ID);
            this.tmpinstance = Util.isParsableToInt(id) ? new SimpleTreeInstance(this.model, Integer.parseInt(id)) : new SimpleTreeInstance(this.model, Util.convertToInt(id));
        } else if (qName.equalsIgnoreCase(X_COORDINATE)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.tmpinstance.setX(Float.parseFloat(value));
            }
        } else if (qName.equalsIgnoreCase(Y_COORDINATE)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.tmpinstance.setY(Float.parseFloat(value));
            }
        } else if (qName.equalsIgnoreCase(ROOT)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.model.setRoot(Integer.parseInt(value));
            }
        } else if (qName.equalsIgnoreCase(TYPE)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.model.setType(value);
            }
        } else if (qName.equalsIgnoreCase(NOALPHA)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.model.setNoAlpha(Boolean.parseBoolean(value));
            }
        } else if (qName.equalsIgnoreCase(ALPHA)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.model.setAlpha(Float.parseFloat(value));
            }
        } else if (qName.equalsIgnoreCase(EDGES)) {
            this.edges = new ArrayList();
            this.con = new SimpleTreeConnectivity(attributes.getValue(NAME), this.edges);
            this.model.addConnectivity(this.con);
            if (this.selconnValue != null && this.con.getName().equalsIgnoreCase(this.selconnValue)) {
                this.model.setSelectedConnectivity(this.con);
            }
        } else if (qName.equalsIgnoreCase(EDGE)) {
            int v1 = Integer.parseInt(attributes.getValue(SOURCE));
            int v2 = Integer.parseInt(attributes.getValue(TARGET));
            float length = -1.0f;
            String aux_len = attributes.getValue(LENGTH);
            if (aux_len != null) {
                length = Float.parseFloat(aux_len);
            }
            Edge ed = new Edge(v1, v2, length);
            this.edges.add(ed);
            SimpleTreeInstance parent = this.model.getInstanceById(v1);
            SimpleTreeInstance son = this.model.getInstanceById(v2);
            if (parent != null && son != null) {
                if (parent.getChildrenId(0) == -1) {
                    parent.setChildrenId(0, v2);
                } else {
                    parent.setChildrenId(1, v2);
                }
                son.setParent(v1);
            }
        } else if (qName.equalsIgnoreCase(VALID)) {
            String value = attributes.getValue(VALUE);
            if (value != null) {
                this.tmpinstance.setValid(Boolean.parseBoolean(value));
            }
        } else if (qName.equalsIgnoreCase(SELCONN)) {
            this.selconnValue = attributes.getValue(VALUE);
            if (this.selconnValue != null && this.model.getConnectivities() != null) {
                for (int i = 0; i < this.model.getConnectivities().size(); ++i) {
                    if (!this.model.getConnectivities().get(i).getName().equalsIgnoreCase(this.selconnValue)) continue;
                    this.model.setSelectedConnectivity(this.model.getConnectivities().get(i));
                }
            }
        }
    }
}

