/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.xml;

import java.io.IOException;
import simpletree.model.SimpleTreeModel;
import simpletree.model.xml.XMLSimpleTreeModelReader;
import simpletree.model.xml.XMLSimpleTreeModelReaderParamView;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Input", name="Tree model XML reader", description="Read a tree model from an XML file.")
public class XMLSimpleTreeModelReaderComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    protected String filename = "";
    protected transient SimpleTreeModel model;
    protected transient XMLSimpleTreeModelReaderParamView paramview;

    public void execute() throws IOException {
        String name;
        if (this.filename.trim().length() > 0) {
            XMLSimpleTreeModelReader xmr = new XMLSimpleTreeModelReader();
            this.model = new SimpleTreeModel();
            xmr.read(this.model, this.filename);
            name = this.filename;
            if (name.lastIndexOf("\\") != -1) {
                name = name.substring(name.lastIndexOf("\\") + 1);
            }
        } else {
            throw new IOException("A tree file name must be provided to write.");
        }
        this.model.setSource(name);
    }

    public SimpleTreeModel output() {
        return this.model;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new XMLSimpleTreeModelReaderParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

