/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.xml;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.model.SimpleTreeModel;
import simpletree.model.xml.XMLSimpleTreeModelReaderComp;
import simpletree.model.xml.XMLSimpleTreeModelSetReaderParamView;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Input", name="Simple Tree Set Reader", description="Read a set of simple tree models.")
public class XMLSimpleTreeModelSetReaderComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    protected String filenames = "";
    protected transient ArrayList<SimpleTreeModel> models;
    protected transient XMLSimpleTreeModelSetReaderParamView paramview;

    public void execute() throws IOException {
        if (this.filenames.trim().length() > 0) {
            XMLSimpleTreeModelReaderComp xmc = new XMLSimpleTreeModelReaderComp();
            String[] files = this.filenames.split(";");
            if (files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    xmc.setFilename(files[i]);
                    xmc.execute();
                    this.models.add(xmc.output());
                }
            }
        } else {
            throw new IOException("A tree set file name must be provided to write.");
        }
    }

    public ArrayList<SimpleTreeModel> output() {
        return this.models;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new XMLSimpleTreeModelSetReaderParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.models = new ArrayList();
    }

    public String getFilesname() {
        return this.filenames;
    }

    public void setFilesname(String filename) {
        this.filenames = filename;
    }
}

