/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import simpletree.model.xml.XMLSimpleTreeModelSetReaderComp;
import simpletree.util.ProjectionOpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.XMLFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class XMLSimpleTreeModelSetReaderParamView
extends AbstractParametersView {
    private XMLSimpleTreeModelSetReaderComp comp;
    private JButton treeSetButton;
    private JLabel treeSetLabel;
    private JButton treeSetSelectDirButton;
    private JTextField treeSetTextField;

    public XMLSimpleTreeModelSetReaderParamView(XMLSimpleTreeModelSetReaderComp comp) {
        this.initComponents();
        this.comp = comp;
        this.reset();
    }

    private void initComponents() {
        this.treeSetLabel = new JLabel();
        this.treeSetTextField = new JTextField();
        this.treeSetButton = new JButton();
        this.treeSetSelectDirButton = new JButton();
        this.setBorder(BorderFactory.createTitledBorder("Tree Set Reader"));
        this.setLayout(new GridBagLayout());
        this.treeSetLabel.setText("Tree File names : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.treeSetLabel, gridBagConstraints);
        this.treeSetTextField.setColumns(35);
        this.treeSetTextField.setMinimumSize(new Dimension(286, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.treeSetTextField, gridBagConstraints);
        this.treeSetButton.setText("Search...");
        this.treeSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLSimpleTreeModelSetReaderParamView.this.treeSetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.treeSetButton, gridBagConstraints);
        this.treeSetSelectDirButton.setText("Select Dir...");
        this.treeSetSelectDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLSimpleTreeModelSetReaderParamView.this.treeSetSelectDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add(this.treeSetSelectDirButton, gridBagConstraints);
    }

    private void treeSetButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = ProjectionOpenDialog.showOpenDialogMultipleFiles(spm, new XMLFilter(), (Component)((Object)this));
            if (result == 0) {
                String filename = ProjectionOpenDialog.getFilename();
                this.treeSetTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(XMLSimpleTreeModelSetReaderParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void treeSetSelectDirButtonActionPerformed(ActionEvent evt) {
        File dir;
        int result = ProjectionOpenDialog.showOpenDirDialog((Component)((Object)this), "");
        if (result == 0 && !ProjectionOpenDialog.getFilename().trim().isEmpty() && (dir = new File(ProjectionOpenDialog.getFilename().trim())) != null & dir.isDirectory()) {
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File b) {
                    return b.getName().endsWith(".xml");
                }
            };
            File[] files = dir.listFiles(ff);
            files = ProjectionOpenDialog.sortFilesByLastModDate(files, 0);
            String filesS = "";
            if (files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    filesS = filesS + files[i] + ";";
                }
                filesS = filesS.substring(0, filesS.length() - 1);
            }
            this.treeSetTextField.setText(filesS);
        }
    }

    public void reset() {
        this.treeSetTextField.setText(this.comp.getFilesname());
    }

    public void finished() throws IOException {
        if (this.treeSetTextField.getText().trim().length() <= 0) {
            throw new IOException("A tree file name must be provided.");
        }
        this.comp.setFilesname(this.treeSetTextField.getText());
    }
}

