/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.stress;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.LightWeightDistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.reader.MatrixReaderComp;
import simpletree.projection.stress.Stress;

public class KruskalStress
extends Stress {
    @Override
    public float calculate(AbstractMatrix projection, AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        LightWeightDistanceMatrix dmat = new LightWeightDistanceMatrix(matrix, diss);
        return this.calculate(projection, dmat);
    }

    @Override
    public float calculate(AbstractMatrix projection, DistanceMatrix dmat) throws IOException {
        LightWeightDistanceMatrix dmatprj = new LightWeightDistanceMatrix(projection, new Euclidean());
        double num = 0.0;
        double den = 0.0;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                double distrn = dmat.getDistance(i, j);
                double distr2 = dmatprj.getDistance(i, j);
                num += (distrn - distr2) * (distrn - distr2);
                den += distrn * distrn;
            }
        }
        return (float)(num / den);
    }

    public static void main(String[] args) {
        try {
            MatrixReaderComp reader1 = new MatrixReaderComp();
            reader1.setFilename("D:\\Dados\\sampling10d2e5.0099-normalized.data");
            reader1.execute();
            AbstractMatrix matrix = reader1.output();
            MatrixReaderComp reader2 = new MatrixReaderComp();
            reader2.setFilename("D:\\projection.data");
            reader2.execute();
            AbstractMatrix proj = reader2.output();
            KruskalStress stress = new KruskalStress();
            float value = stress.calculate(proj, matrix, new Euclidean());
            System.out.println("Stress: " + value);
        }
        catch (IOException ex) {
            Logger.getLogger(KruskalStress.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

