/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.stress;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.LightWeightDistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.projection.stress.Stress;

public class NormalizedKruskalStress
extends Stress {
    @Override
    public float calculate(AbstractMatrix projection, AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        LightWeightDistanceMatrix dmat = new LightWeightDistanceMatrix(matrix, diss);
        return this.calculate(projection, dmat);
    }

    @Override
    public float calculate(AbstractMatrix projection, DistanceMatrix dmat) throws IOException {
        LightWeightDistanceMatrix dmatprj = new LightWeightDistanceMatrix(projection, new Euclidean());
        double maxrn = Double.NEGATIVE_INFINITY;
        double maxr2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                double valuern = dmat.getDistance(i, j);
                double valuer2 = dmatprj.getDistance(i, j);
                if (valuern > maxrn) {
                    maxrn = valuern;
                }
                if (!(valuer2 > maxr2)) continue;
                maxr2 = valuer2;
            }
        }
        double num = 0.0;
        double den = 0.0;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                double distrn = (double)dmat.getDistance(i, j) / maxrn;
                double distr2 = (double)dmatprj.getDistance(i, j) / maxr2;
                num += (distrn - distr2) * (distrn - distr2);
                den += distrn * distrn;
            }
        }
        return (float)(num / den);
    }
}

