/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.stress;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.LightWeightDistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.projection.stress.Stress;

public class PartialNormalizedKruskalStress
extends Stress {
    @Override
    public float calculate(AbstractMatrix projection, AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        LightWeightDistanceMatrix dmat = new LightWeightDistanceMatrix(matrix, diss);
        return this.calculate(projection, dmat);
    }

    @Override
    public float calculate(AbstractMatrix projection, DistanceMatrix dmat) throws IOException {
        LightWeightDistanceMatrix dmatprj = new LightWeightDistanceMatrix(projection, new Euclidean());
        float perc = 2.5E-4f;
        long nrelements = ((long)dmatprj.getElementCount() * (long)dmatprj.getElementCount() - (long)dmatprj.getElementCount()) / 2L;
        HashSet<Long> index_aux = new HashSet<Long>();
        while ((float)index_aux.size() < perc * (float)nrelements) {
            long value = (int)(Math.random() * (double)nrelements);
            index_aux.add(value);
        }
        ArrayList index = new ArrayList(index_aux);
        Collections.sort(index);
        double maxrn = Double.NEGATIVE_INFINITY;
        double maxr2 = Double.NEGATIVE_INFINITY;
        long count = 0L;
        int r = 0;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                if (r < index.size() && (Long)index.get(r) == count) {
                    ++r;
                    double valuern = dmat.getDistance(i, j);
                    double valuer2 = dmatprj.getDistance(i, j);
                    if (valuern > maxrn) {
                        maxrn = valuern;
                    }
                    if (valuer2 > maxr2) {
                        maxr2 = valuer2;
                    }
                }
                ++count;
            }
        }
        double num = 0.0;
        double den = 0.0;
        count = 0L;
        int r2 = 0;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                if (r2 < index.size() && (Long)index.get(r2) == count) {
                    ++r2;
                    double distrn = (double)dmat.getDistance(i, j) / maxrn;
                    double distr2 = (double)dmatprj.getDistance(i, j) / maxr2;
                    num += (distrn - distr2) * (distrn - distr2);
                    den += distrn * distrn;
                }
                ++count;
            }
        }
        return (float)(num / den);
    }
}

