/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.stress;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.LightWeightDistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.projection.stress.Stress;

public class SammonStress
extends Stress {
    @Override
    public float calculate(AbstractMatrix projection, AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        LightWeightDistanceMatrix dmat = new LightWeightDistanceMatrix(matrix, diss);
        return this.calculate(projection, dmat);
    }

    @Override
    public float calculate(AbstractMatrix projection, DistanceMatrix dmat) throws IOException {
        LightWeightDistanceMatrix dmatprj = new LightWeightDistanceMatrix(projection, new Euclidean());
        float num = 0.0f;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                num += (dmat.getDistance(i, j) - dmatprj.getDistance(i, j)) * (dmat.getDistance(i, j) - dmatprj.getDistance(i, j)) / (dmat.getDistance(i, j) * dmat.getDistance(i, j));
            }
        }
        float den = 0.0f;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            for (int j = i + 1; j < dmat.getElementCount(); ++j) {
                den += dmat.getDistance(i, j) * dmat.getDistance(i, j);
            }
        }
        return num / den;
    }
}

