/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.stress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.projection.stress.StressComp;
import simpletree.projection.stress.StressFactory;
import vispipelinebasics.interfaces.AbstractParametersView;

public class StressParamView
extends AbstractParametersView {
    private StressComp comp;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JComboBox stressComboBox;
    private JPanel stressPanel;

    public StressParamView(StressComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType dissimilarityType : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(dissimilarityType);
        }
        for (Enum enum_ : StressFactory.StressType.values()) {
            this.stressComboBox.addItem(enum_);
        }
        this.reset();
    }

    private void initComponents() {
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.stressPanel = new JPanel();
        this.stressComboBox = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("Stress Parameters"));
        this.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.stressPanel.setBorder(BorderFactory.createTitledBorder("Stress Technique"));
        this.stressPanel.setLayout(new BorderLayout());
        this.stressPanel.add((Component)this.stressComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add(this.stressPanel, gridBagConstraints);
    }

    public void reset() {
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        }
        this.stressComboBox.setSelectedItem((Object)this.comp.getStressType());
    }

    public void finished() throws IOException {
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
        this.comp.setStressType((StressFactory.StressType)((Object)this.stressComboBox.getSelectedItem()));
    }
}

