/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.fastmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.projection.technique.Projection;

public class FastmapProjection2D
implements Projection {
    @Override
    public AbstractMatrix project(DistanceMatrix dmat) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractMatrix project(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        long start = System.currentTimeMillis();
        float[][] projection_aux = new float[matrix.getRowCount()][2];
        if (matrix.getRowCount() <= 4) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.doTheFastmap(matrix, diss, projection_aux);
        DenseMatrix projection = new DenseMatrix();
        ArrayList<Integer> ids = matrix.getIds();
        float[] classData = matrix.getClassData();
        ArrayList<String> labels = matrix.getLabels();
        for (int i = 0; i < projection_aux.length; ++i) {
            if (labels.isEmpty()) {
                projection.addRow(new DenseVector(projection_aux[i], ids.get(i), classData[i]));
                continue;
            }
            projection.addRow(new DenseVector(projection_aux[i], ids.get(i), classData[i]), labels.get(i));
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Fastmap Projection time: {0}s", Float.valueOf((float)(finish - start) / 1000.0f));
        return projection;
    }

    private void doTheFastmap(AbstractMatrix matrix, AbstractDissimilarity diss, float[][] projection) {
        this.project(matrix, diss, projection, 0);
        this.project(matrix, diss, projection, 1);
    }

    private void project(AbstractMatrix matrix, AbstractDissimilarity diss, float[][] projection, int dimension) {
        int[] lvchoosen = this.chooseDistantObjects(matrix, diss, projection, dimension);
        float lvdistance = this.distance(matrix.getRow(lvchoosen[0]), matrix.getRow(lvchoosen[1]), projection[lvchoosen[0]], projection[lvchoosen[1]], diss, dimension);
        if (lvdistance == 0.0f) {
            for (int lvi = 0; lvi < projection.length; ++lvi) {
                projection[lvi][dimension] = 0.0f;
            }
        } else {
            for (int lvi = 0; lvi < projection.length; ++lvi) {
                float lvxi;
                float dist_lvchoosen0_lvi = this.distance(matrix.getRow(lvchoosen[0]), matrix.getRow(lvi), projection[lvchoosen[0]], projection[lvi], diss, dimension);
                float dist_lvchoosen0_lvchoosen1 = this.distance(matrix.getRow(lvchoosen[0]), matrix.getRow(lvchoosen[1]), projection[lvchoosen[0]], projection[lvchoosen[1]], diss, dimension);
                float dist_lvchoosen1_lvi = this.distance(matrix.getRow(lvchoosen[1]), matrix.getRow(lvi), projection[lvchoosen[1]], projection[lvi], diss, dimension);
                projection[lvi][dimension] = lvxi = (float)((Math.pow(dist_lvchoosen0_lvi, 2.0) + Math.pow(dist_lvchoosen0_lvchoosen1, 2.0) - Math.pow(dist_lvchoosen1_lvi, 2.0)) / (double)(2.0f * dist_lvchoosen0_lvchoosen1));
            }
        }
    }

    private float distance(AbstractVector v1, AbstractVector v2, float[] p1, float[] p2, AbstractDissimilarity diss, int dimension) {
        float dist = diss.calculate(v1, v2);
        int i = 0;
        if (i < dimension) {
            float coord1 = p1[dimension - 1];
            float coord2 = p2[dimension - 1];
            return (float)Math.sqrt(Math.abs(Math.pow(diss.calculate(v1, v2), 2.0) - Math.pow(coord1 - coord2, 2.0)));
        }
        return dist;
    }

    private int[] chooseDistantObjects(AbstractMatrix matrix, AbstractDissimilarity diss, float[][] projection, int dimension) {
        int[] choosen = new int[2];
        int pivot1 = 0;
        int pivot2 = 0;
        int size = matrix.getRowCount();
        float max = Float.NEGATIVE_INFINITY;
        for (int k = 0; k < 5; ++k) {
            float dist;
            int i;
            int initialpivot = (int)(Math.random() * (double)(matrix.getRowCount() - 1));
            float max_aux = Float.NEGATIVE_INFINITY;
            for (i = 0; i < size; ++i) {
                dist = this.distance(matrix.getRow(initialpivot), matrix.getRow(i), projection[initialpivot], projection[i], diss, dimension);
                if (!(dist > max_aux)) continue;
                max_aux = dist;
                pivot1 = i;
            }
            max_aux = Float.NEGATIVE_INFINITY;
            for (i = 0; i < size; ++i) {
                dist = this.distance(matrix.getRow(pivot1), matrix.getRow(i), projection[pivot1], projection[i], diss, dimension);
                if (!(dist > max_aux)) continue;
                max_aux = dist;
                pivot2 = i;
            }
            if (!(max_aux > max)) continue;
            choosen[0] = pivot1;
            choosen[1] = pivot2;
        }
        return choosen;
    }
}

