/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.fastmap;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.reader.MatrixReaderComp;
import simpletree.model.ProjectionModelComp;
import simpletree.projection.technique.fastmap.FastmapProjection2D;
import simpletree.view.ProjectionFrameComp;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Technique", name="Fastmap", description="Project points from a multidimensional space to the plane preserving the distance relations.", howtocite="???")
public class FastmapProjection2DComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private transient AbstractMatrix projection;
    private transient AbstractMatrix matrix;

    public void execute() throws IOException {
        if (this.matrix == null) {
            throw new IOException("A points matrix should be provided.");
        }
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
        FastmapProjection2D fastmap = new FastmapProjection2D();
        this.projection = fastmap.project(this.matrix, diss);
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public AbstractMatrix output() {
        return this.projection;
    }

    public AbstractParametersView getParametersEditor() {
        return null;
    }

    public void reset() {
        this.projection = null;
        this.matrix = null;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public static void main(String[] args) {
        try {
            MatrixReaderComp reader = new MatrixReaderComp();
            reader.setFilename("D:\\Meus documentos\\FERNANDO\\Artigos\\2010\\mv_vis_2010\\code\\data\\mammals-7000-normcols.bin");
            reader.execute();
            AbstractMatrix matrix = reader.output();
            FastmapProjection2DComp fastmap = new FastmapProjection2DComp();
            fastmap.setDissimilarityType(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
            fastmap.input(matrix);
            fastmap.execute();
            AbstractMatrix projection = fastmap.output();
            ProjectionModelComp model = new ProjectionModelComp();
            model.input(projection);
            model.execute();
            ProjectionFrameComp frame = new ProjectionFrameComp();
            frame.setTitle("Complete Projection");
            frame.input(model.output());
            frame.execute();
        }
        catch (IOException ex) {
            Logger.getLogger(FastmapProjection2DComp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

