/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.force;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.projection.technique.Projection;

public class ForceSchemeProjection2D
implements Projection {
    private double normfactor;
    private float fractionDelta = 8.0f;
    private int[] index;
    private int nriterations = 50;
    private AbstractMatrix projection;
    private static final float EPSILON = 1.0E-7f;

    @Override
    public AbstractMatrix project(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.project(dmat);
    }

    @Override
    public AbstractMatrix project(DistanceMatrix dmat) throws IOException {
        int i;
        this.normfactor = 0.0;
        for (int i2 = 0; i2 < dmat.getElementCount(); ++i2) {
            for (int j = 0; j < i2; ++j) {
                this.normfactor += (double)(dmat.getDistance(i2, j) * dmat.getDistance(i2, j));
            }
        }
        ArrayList<Integer> index_aux = new ArrayList<Integer>();
        for (int i3 = 0; i3 < dmat.getElementCount(); ++i3) {
            index_aux.add(i3);
        }
        this.index = new int[dmat.getElementCount()];
        int ind = 0;
        for (int j = 0; j < this.index.length; ++j) {
            if (ind >= index_aux.size()) {
                ind = 0;
            }
            this.index[j] = (Integer)index_aux.get(ind);
            index_aux.remove(ind);
            ind += index_aux.size() / 10;
        }
        if (this.projection == null) {
            this.projection = new DenseMatrix();
            ArrayList<Integer> ids = dmat.getIds();
            float[] classData = dmat.getClassData();
            ArrayList<String> labels = dmat.getLabels();
            for (int i4 = 0; i4 < dmat.getElementCount(); ++i4) {
                float[] point = new float[]{(float)Math.random(), (float)Math.random()};
                if (labels.isEmpty()) {
                    this.projection.addRow(new DenseVector(point, ids.get(i4), classData[i4]));
                    continue;
                }
                this.projection.addRow(new DenseVector(point, ids.get(i4), classData[i4]), labels.get(i4));
            }
        }
        float[][] aux_proj = this.projection.toMatrix();
        for (i = 0; i < this.nriterations; ++i) {
            this.iteration(dmat, aux_proj);
        }
        for (i = 0; i < aux_proj.length; ++i) {
            this.projection.getRow(i).setValue(0, aux_proj[i][0]);
            this.projection.getRow(i).setValue(1, aux_proj[i][1]);
        }
        return this.projection;
    }

    private void iteration(DistanceMatrix dmat, float[][] aux_proj) {
        for (int ins1 = 0; ins1 < aux_proj.length; ++ins1) {
            int instance = this.index[ins1];
            for (int ins2 = 0; ins2 < aux_proj.length; ++ins2) {
                int instance2 = this.index[ins2];
                if (instance == instance2) continue;
                double x1x2 = aux_proj[instance2][0] - aux_proj[instance][0];
                double y1y2 = aux_proj[instance2][1] - aux_proj[instance][1];
                double dr2 = Math.sqrt(x1x2 * x1x2 + y1y2 * y1y2);
                if (dr2 < (double)1.0E-7f) {
                    dr2 = 1.0E-7f;
                }
                float drn = dmat.getDistance(instance, instance2);
                double delta = (double)drn - dr2;
                float[] fArray = aux_proj[instance2];
                fArray[0] = (float)((double)fArray[0] + (delta /= (double)this.fractionDelta) * (x1x2 / dr2));
                float[] fArray2 = aux_proj[instance2];
                fArray2[1] = (float)((double)fArray2[1] + delta * (y1y2 / dr2));
                if (aux_proj[instance2][0] == aux_proj[instance2][0]) continue;
                System.out.println("Error: Force Scheme >> delta" + delta + ", x1x2=" + x1x2 + ", dr2=" + dr2 + ", drn=" + drn);
            }
        }
    }

    public void setFractionDelta(float fractionDelta) {
        this.fractionDelta = fractionDelta;
    }

    public void setNumberIterations(int nriterations) {
        this.nriterations = nriterations;
    }

    public void setProjection(AbstractMatrix projection) {
        this.projection = projection;
    }
}

