/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.isomap;

import java.io.IOException;
import simpletree.datamining.neighbors.KNN;
import simpletree.datamining.neighbors.Pair;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.reader.MatrixReaderComp;
import simpletree.model.ProjectionModelComp;
import simpletree.projection.technique.Projection;
import simpletree.projection.technique.isomap.Dijkstra;
import simpletree.projection.technique.isomap.ISOMAPProjectionComp;
import simpletree.projection.technique.mds.ClassicalMDSProjection;
import simpletree.util.ConnectedGraphGenerator;
import simpletree.util.MeshGenerator;
import simpletree.util.ProjectionUtil;
import simpletree.view.ProjectionFrameComp;

public class ISOMAPProjection
implements Projection {
    private int nrneighbors = 10;

    @Override
    public AbstractMatrix project(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        DistanceMatrix new_dmat = new DistanceMatrix(matrix.getRowCount());
        new_dmat.setIds(matrix.getIds());
        new_dmat.setClassData(matrix.getClassData());
        KNN knn = new KNN(this.nrneighbors);
        Pair[][] neighborhood = knn.execute(matrix, diss);
        ConnectedGraphGenerator cgg = new ConnectedGraphGenerator();
        cgg.execute(neighborhood, matrix, diss);
        Dijkstra d = new Dijkstra(neighborhood);
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            float[] dist = d.execute(i);
            for (int j = 0; j < dist.length; ++j) {
                new_dmat.setDistance(i, j, dist[j]);
                if (dist[j] != Float.POSITIVE_INFINITY) continue;
                System.out.println("Error.... ISOMAP");
                return new DenseMatrix();
            }
        }
        ClassicalMDSProjection cmds = new ClassicalMDSProjection();
        return cmds.project(new_dmat);
    }

    @Override
    public AbstractMatrix project(DistanceMatrix dmat) throws IOException {
        DistanceMatrix new_dmat = new DistanceMatrix(dmat.getElementCount());
        new_dmat.setIds(dmat.getIds());
        new_dmat.setLabels(dmat.getLabels());
        new_dmat.setClassData(dmat.getClassData());
        KNN knn = new KNN(this.nrneighbors);
        Pair[][] neighborhood = knn.execute(dmat);
        MeshGenerator meshgen = new MeshGenerator();
        neighborhood = meshgen.execute(neighborhood, dmat);
        Dijkstra d = new Dijkstra(neighborhood);
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            float[] dist = d.execute(i);
            for (int j = 0; j < dist.length; ++j) {
                new_dmat.setDistance(i, j, dist[j]);
            }
        }
        ClassicalMDSProjection cmds = new ClassicalMDSProjection();
        return cmds.project(new_dmat);
    }

    public int getNumberNeighbors() {
        return this.nrneighbors;
    }

    public void setNumberNeighbors(int nrneighbors) {
        this.nrneighbors = nrneighbors;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("ERROR! It should be: ISOMAPProjection filename.data");
            System.exit(1);
        }
        ProjectionUtil.log(false, false);
        System.out.println("========================");
        System.out.println("ISOMAP - processing: " + args[0]);
        MatrixReaderComp reader = new MatrixReaderComp();
        reader.setFilename(args[0]);
        reader.execute();
        AbstractMatrix matrix = reader.output();
        long start = System.currentTimeMillis();
        ISOMAPProjectionComp isomap = new ISOMAPProjectionComp();
        isomap.setDissimilarityType(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        if (matrix.getRowCount() < 1500) {
            isomap.setNumberNeighbors(10);
        } else if (matrix.getRowCount() < 5000) {
            isomap.setNumberNeighbors(15);
        } else {
            isomap.setNumberNeighbors(20);
        }
        isomap.input(matrix);
        isomap.execute();
        AbstractMatrix projection = isomap.output();
        long finish = System.currentTimeMillis();
        System.out.println("ISOMAP projection time: " + (float)(finish - start) / 1000.0f + "s");
        projection.save(args[0] + "-isomap.prj");
        ProjectionModelComp model = new ProjectionModelComp();
        model.input(projection);
        model.execute();
        ProjectionFrameComp frame = new ProjectionFrameComp();
        frame.input(model.output());
        frame.execute();
        System.out.println("ISOMAP - end");
        System.out.println("========================");
    }
}

