/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.isomap;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.projection.technique.isomap.ISOMAPProjection;
import simpletree.projection.technique.isomap.ISOMAPProjectionParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Technique", name="Isometric Feature Mapping (ISOMAP)", description="Project points from a multidimensional space to the plane preserving the geodesic distance relations.", howtocite="Tenenbaum, J. B.; Silva, V.; Langford, J. C. A global geometric framework for nonlinear dimensionality reduction. Science, v. 290, n. 5500, p. 2319-2323, 2000.")
public class ISOMAPProjectionComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private int nrneighbors = 10;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private transient ISOMAPProjectionParamView paramview;
    private transient AbstractMatrix projection;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;

    public void execute() throws IOException {
        ISOMAPProjection isomap = new ISOMAPProjection();
        isomap.setNumberNeighbors(this.nrneighbors);
        if (this.matrix != null) {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            this.projection = isomap.project(this.matrix, diss);
        } else if (this.dmat != null) {
            this.projection = isomap.project(this.dmat);
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public void input(@Param(name="distance matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public AbstractMatrix output() {
        return this.projection;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new ISOMAPProjectionParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.projection = null;
        this.matrix = null;
        this.dmat = null;
    }

    public int getNumberNeighbors() {
        return this.nrneighbors;
    }

    public void setNumberNeighbors(int nrneighbors) {
        this.nrneighbors = nrneighbors;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public boolean isDistanceMatrixProvided() {
        return this.dmat != null;
    }
}

