/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.technique.mds;

import java.io.IOException;
import java.util.ArrayList;
import mdsj.ClassicalScaling;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.LightWeightDistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.matrix.reader.MatrixReaderComp;
import simpletree.model.ProjectionModelComp;
import simpletree.projection.technique.Projection;
import simpletree.projection.technique.mds.ClassicalMDSProjectionComp;
import simpletree.util.ProjectionUtil;
import simpletree.view.ProjectionFrameComp;

public class ClassicalMDSProjection
implements Projection {
    @Override
    public AbstractMatrix project(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        LightWeightDistanceMatrix dmat = new LightWeightDistanceMatrix(matrix, diss);
        return this.project(dmat);
    }

    @Override
    public AbstractMatrix project(DistanceMatrix dmat) throws IOException {
        int size = dmat.getElementCount();
        double[][] input = new double[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                double d = dmat.getDistance(i, j);
                input[j][i] = d;
                input[i][j] = d;
            }
        }
        double[][] output = new double[2][size];
        ClassicalScaling.fullmds((double[][])input, (double[][])output);
        input = null;
        System.gc();
        DenseMatrix projection = new DenseMatrix();
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("x");
        attributes.add("y");
        projection.setAttributes(attributes);
        ArrayList<Integer> ids = dmat.getIds();
        ArrayList<String> labels = dmat.getLabels();
        float[] classData = dmat.getClassData();
        for (int i = 0; i < size; ++i) {
            float[] vect = new float[]{(float)output[0][i], (float)output[1][i]};
            if (labels.isEmpty()) {
                ((AbstractMatrix)projection).addRow(new DenseVector(vect, ids.get(i), classData[i]));
                continue;
            }
            projection.addRow(new DenseVector(vect, ids.get(i), classData[i]), labels.get(i));
        }
        return projection;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("ERROR! It should be: ClassicalMDSProjection filename.data");
            System.exit(1);
        }
        ProjectionUtil.log(false, false);
        MatrixReaderComp reader = new MatrixReaderComp();
        reader.setFilename(args[0]);
        reader.execute();
        AbstractMatrix matrix = reader.output();
        ClassicalMDSProjectionComp cmds = new ClassicalMDSProjectionComp();
        cmds.setDissimilarityType(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        cmds.input(matrix);
        cmds.execute();
        AbstractMatrix projection = cmds.output();
        ProjectionModelComp model = new ProjectionModelComp();
        model.input(projection);
        model.execute();
        ProjectionFrameComp frame = new ProjectionFrameComp();
        frame.input(model.output());
        frame.execute();
    }
}

