/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.datamining.clustering.BKmeans;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.model.ProjectionInstance;
import simpletree.model.Scalar;
import simpletree.projectioncloud.projection.ProjectionPolygonModel;
import simpletree.textprocessing.corpus.zip.ZipCorpus;
import simpletree.textprocessing.processing.Preprocessor;
import simpletree.textprocessing.processing.stemmer.StemmerFactory;
import simpletree.view.ProjectionFrame;

public class Main {
    public static void main(String[] args) throws IOException {
        String corpusfilename = "/home/renato/workspace/Data/Datasets/Text/cbr-ilp-ir-son-int.zip";
        int lowercut = 5;
        int uppercut = -1;
        int nrclusters = 3;
        ZipCorpus corpus = new ZipCorpus(corpusfilename, 1);
        Preprocessor preproc = new Preprocessor(corpus);
        AbstractMatrix matrixtf = preproc.getMatrix(lowercut, uppercut, 1, StemmerFactory.StemmerType.NONE);
        AbstractMatrix proj = MatrixFactory.getInstance("/media/renato/DADOS/workspace/VisPipelineWorkspace/VisPipeline-Renato/ProjectionCloud/cbr-ilp-ir-son-int.lsp.data");
        ProjectionPolygonModel model = new ProjectionPolygonModel();
        Scalar cdata = model.addScalar("cdata");
        Scalar dots = model.addScalar("...");
        int nrows = proj.getRowCount();
        for (int i = 0; i < nrows; ++i) {
            AbstractVector row = proj.getRow(i);
            ProjectionInstance pi = new ProjectionInstance(row.getId(), row.getValue(0), row.getValue(1));
            model.addInstance(pi);
            pi.setScalarValue(cdata, row.getKlass());
            pi.setScalarValue(dots, 0.0f);
        }
        BKmeans kmeans = new BKmeans(nrclusters);
        ArrayList<ArrayList<Integer>> clusters = kmeans.execute(new Euclidean(), proj);
        model.setClusters(clusters);
        model.createTopics(matrixtf);
        ProjectionFrame frame = new ProjectionFrame();
        frame.setSize(1200, 1200);
        frame.setModel(model);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

