/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.fill;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import simpletree.matrix.AbstractMatrix;
import simpletree.model.AbstractInstance;
import simpletree.model.ProjectionInstance;
import simpletree.projectioncloud.fill.PolygonCoverage;
import simpletree.projectioncloud.fill.TermRectangle;
import simpletree.projectioncloud.projection.ConvexHull;
import simpletree.projectioncloud.topic.GraphTopic;
import simpletree.projectioncloud.topic.Term;
import simpletree.projectioncloud.util.Util;

public class Group {
    private static final int fontmax = 30;
    private static final int fontmin = 12;
    private static final String fontname = "Cooper Black";
    private ArrayList<TermRectangle> rectangles;
    private ArrayList<Term> terms;
    private ArrayList<Integer> elements;
    private Polygon polygon;
    private Rectangle boundingBox;

    public Group(ArrayList<Integer> elements) {
        this.elements = elements;
    }

    public void draw(BufferedImage image, boolean highquality) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        this.draw(g2, highquality);
    }

    public void draw(Graphics2D g2, boolean highquality) {
        if (this.polygon != null) {
            // empty if block
        }
        if (this.terms != null) {
            if (highquality) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (this.rectangles != null) {
                for (int i = 0; i < this.rectangles.size(); ++i) {
                    this.rectangles.get(i).draw(g2);
                }
            }
            this.dump();
        }
    }

    public void setTerms(ArrayList<Term> terms) {
        int i;
        this.terms = terms;
        float max = Float.NEGATIVE_INFINITY;
        float min = Float.POSITIVE_INFINITY;
        for (i = 0; i < terms.size(); ++i) {
            float w = terms.get((int)i).weight;
            if (max < w) {
                max = w;
            }
            if (!(min > w)) continue;
            min = w;
        }
        for (i = 0; i < terms.size(); ++i) {
            terms.get((int)i).weight = (terms.get((int)i).weight - min) / (max - min);
        }
    }

    public ArrayList<Term> calculateTerms(AbstractMatrix matrix) throws IOException {
        int i;
        GraphTopic gt = new GraphTopic(matrix);
        this.terms = gt.create(this.elements, 30);
        float max = Float.NEGATIVE_INFINITY;
        float min = Float.POSITIVE_INFINITY;
        for (i = 0; i < this.terms.size(); ++i) {
            float w = this.terms.get((int)i).weight;
            if (max < w) {
                max = w;
            }
            if (!(min > w)) continue;
            min = w;
        }
        for (i = 0; i < this.terms.size(); ++i) {
            this.terms.get((int)i).weight = (this.terms.get((int)i).weight - min) / (max - min);
        }
        return this.terms;
    }

    public void distributeWeightsLinearly() {
        Collections.sort(this.terms, new Comparator(){

            public int compare(Object o1, Object o2) {
                Term t1 = (Term)o1;
                Term t2 = (Term)o2;
                return Float.compare(t1.weight, t2.weight);
            }
        });
        float currentWeight = 0.0f;
        float step = 1.0f / (float)this.terms.size();
        for (int i = 0; i < this.terms.size(); ++i) {
            this.terms.get((int)i).weight = currentWeight;
            currentWeight += step;
        }
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public Polygon calculateConvexHullPolygon(ArrayList<AbstractInstance> instances) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        for (int j = 0; j < this.elements.size(); ++j) {
            ProjectionInstance pi = (ProjectionInstance)instances.get(this.elements.get(j));
            points.add(new Point2D.Float(pi.getY(), pi.getX()));
            if (pi.getX() > maxX) {
                maxX = pi.getX();
            }
            if (pi.getX() < minX) {
                minX = pi.getX();
            }
            if (pi.getY() > maxY) {
                maxY = pi.getY();
            }
            if (!(pi.getY() < minY)) continue;
            minY = pi.getY();
        }
        this.boundingBox = new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
        ConvexHull ch = new ConvexHull();
        ArrayList<Point2D> hull = ch.execute(points);
        this.polygon = new Polygon();
        for (int j = 0; j < hull.size(); ++j) {
            Point2D point = hull.get(j);
            this.polygon.addPoint((int)point.getX(), (int)point.getY());
        }
        return this.polygon;
    }

    public void fillPolygon() {
        this.rectangles = new ArrayList();
        this.calculateFontSize(this.rectangles);
        PolygonCoverage pc = new PolygonCoverage();
        pc.execute(this.polygon, this.rectangles);
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public void setPolygon(Polygon polygon) {
        this.polygon = polygon;
    }

    public ArrayList<Term> getTerms() {
        return this.terms;
    }

    private void calculateFontSize(ArrayList<TermRectangle> rectangles) {
        if (this.terms != null) {
            float polarea = Util.calcArea(this.polygon);
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (int i = 0; i < this.terms.size(); ++i) {
                float w = this.terms.get((int)i).weight;
                if (max < w) {
                    max = w;
                }
                if (!(min > w)) continue;
                min = w;
            }
            float rectarea = 0.0f;
            for (int i = 0; i < this.terms.size(); ++i) {
                Term term = this.terms.get(i);
                if (max > min) {
                    int fontsize = (int)((term.weight - min) / (max - min) * 18.0f + 12.0f);
                    TermRectangle rect = new TermRectangle(this.terms.get(i), new Font(fontname, 0, fontsize));
                    rectangles.add(rect);
                    rectarea += (float)(rect.width * rect.height);
                    continue;
                }
                TermRectangle rect = new TermRectangle(this.terms.get(i), new Font(fontname, 0, 30));
                rectangles.add(rect);
                rectarea += (float)(rect.width * rect.height);
            }
            float scale = Math.max(1.0f, 2.0f * (float)Math.sqrt(polarea / rectarea));
            for (TermRectangle r : rectangles) {
                r.scale(scale);
            }
        }
    }

    public void dump() {
    }

    public void dumpWordle() {
    }
}

