/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projectioncloud.projection;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ConvexHull {
    public static final double EPSILON = 1.0E-6;

    public ArrayList<Point2D> execute(ArrayList<Point2D> array) {
        Collections.sort(array, new Comparator<Point2D>(){

            @Override
            public int compare(Point2D pt1, Point2D pt2) {
                double diffx = pt1.getX() - pt2.getX();
                if (Math.abs(diffx) < 1.0E-6) {
                    return diffx > 0.0 ? 1 : -1;
                }
                return pt1.getY() - pt2.getY() > 0.0 ? 1 : -1;
            }
        });
        return this.cHull(array);
    }

    private ArrayList<Point2D> cHull(ArrayList<Point2D> array) {
        int size = array.size();
        if (size < 2) {
            return null;
        }
        Point2D l = array.get(0);
        Point2D r = array.get(size - 1);
        ArrayList<Point2D> path = new ArrayList<Point2D>();
        path.add(l);
        this.cHull(array, l, r, path);
        path.add(r);
        this.cHull(array, r, l, path);
        return path;
    }

    private double distance(Point2D p1, Point2D p2, Point2D p3) {
        double x1 = p1.getX();
        double x2 = p2.getX();
        double x3 = p3.getX();
        double y1 = p1.getY();
        double y2 = p2.getY();
        double y3 = p3.getY();
        return x1 * y2 + x3 * y1 + x2 * y3 - x3 * y2 - x2 * y1 - x1 * y3;
    }

    private void cHull(ArrayList<Point2D> points, Point2D l, Point2D r, ArrayList<Point2D> path) {
        if (points.size() < 3) {
            return;
        }
        double maxDist = Double.NEGATIVE_INFINITY;
        Point2D p = null;
        for (Point2D pt : points) {
            double tmp;
            if (pt == l || pt == r || !((tmp = this.distance(l, r, pt)) > maxDist)) continue;
            maxDist = tmp;
            p = pt;
        }
        ArrayList<Point2D> left = new ArrayList<Point2D>();
        ArrayList<Point2D> right = new ArrayList<Point2D>();
        left.add(l);
        right.add(p);
        for (Point2D pt : points) {
            if (this.distance(l, p, pt) > 0.0) {
                left.add(pt);
                continue;
            }
            if (!(this.distance(p, r, pt) > 0.0)) continue;
            right.add(pt);
        }
        left.add(p);
        right.add(r);
        this.cHull(left, l, p, path);
        path.add(p);
        this.cHull(right, p, r, path);
    }
}

